/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.rest.validator;

import com.comalatech.confluence.documentActivity.rest.model.DocumentActivityReportRequest;
import com.comalatech.confluence.documentActivity.rest.model.DocumentActivityRequest;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import java.util.Objects;

public class RequestValidator {
    public void validateTarget(DocumentActivityReportRequest query) {
        if (query == null) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory scope");
        }
        RequestValidator.validateBasicFilters(query.getFilters());
    }

    public void validateTarget(DocumentActivityRequest query) {
        if (query == null) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory scope");
        }
        RequestValidator.validateBasicFilters(query.getFilters());
    }

    private static void validateBasicFilters(DocumentActivityQueryFilter filters) {
        if (Objects.isNull(filters) || Objects.isNull(filters.getScope()) || Objects.isNull(filters.getScope().getPageIds()) && Objects.isNull(filters.getScope().getSpaceKeys())) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory scope");
        }
    }

    public void validatePages(DocumentActivityQueryFilter filters) {
        if (Objects.isNull(filters.getScope().getPageIds())) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory pageIds");
        }
    }

    public void validateSpaces(DocumentActivityQueryFilter filters) {
        if (Objects.isNull(filters.getScope().getSpaceKeys())) {
            throw new IllegalArgumentException("Invalid query data received. No filters or no mandatory spaceKeys");
        }
    }
}

