/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.state;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.event.StateExpiryUpdatedEvent;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.WorkflowUserException;
import java.util.Date;

public class StateDueDateMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public StateDueDateMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof StateExpiryUpdatedEvent) {
            StateExpiryUpdatedEvent stateExpiryUpdatedEvent = (StateExpiryUpdatedEvent)event;
            PageState state = stateExpiryUpdatedEvent.getState();
            return this.buildActivity(stateExpiryUpdatedEvent.getAbstractPage(), stateExpiryUpdatedEvent.getState(), state.getCurrentDueDate());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, DueDateRecord dueDateRecord) throws WorkflowUserException {
        ActionType transition = new ActionType();
        transition.setType(ActionType.Type.STATE);
        Date expiryDate = dueDateRecord.getDueDate();
        if (expiryDate == null) {
            transition.setSubtype(ActionType.Subtype.STATE_EXPIRY_REMOVED);
        } else {
            transition.setSubtype(ActionType.Subtype.STATE_EXPIRY_UPDATE);
        }
        ActionDetails details = new ActionDetails();
        details.addAll(this.buildStateActionDetails(state));
        if (expiryDate != null) {
            details.addDetail(ActionDetailType.NEW_EXPIRY_DATE, String.valueOf(expiryDate.getTime()));
        }
        Action action = new Action(transition, this.actorUtils.buildActor(dueDateRecord.getPerformer()), details);
        return new Activity(StateDueDateMapper.buildTarget((ContentEntityObject)abstractPage), dueDateRecord.getDate().getTime(), action);
    }
}

