/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor.builder.report;

import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.FilterBuilder;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;

public class UsersFilterBuilder
implements FilterBuilder {
    @Override
    public Query build(DocumentActivityQuery query) {
        return this.getQuery(query, false);
    }

    @Override
    public Query build(DocumentActivityQuery query, boolean aliasRequired) {
        return this.getQuery(query, aliasRequired);
    }

    @Override
    public boolean shouldApply(DocumentActivityQuery query) {
        return this.shouldApplyToActors(query) || this.shouldApplyToParticipants(query);
    }

    public boolean shouldApplyToActors(DocumentActivityQuery query) {
        DocumentActivityQueryFilter filters = (DocumentActivityQueryFilter)query.getFilters();
        return filters != null && filters.getActors() != null && !filters.getActors().isEmpty();
    }

    public boolean shouldApplyToParticipants(DocumentActivityQuery query) {
        DocumentActivityQueryFilter filters = (DocumentActivityQueryFilter)query.getFilters();
        return filters != null && filters.getParticipants() != null && !filters.getParticipants().isEmpty();
    }

    private Query getQuery(DocumentActivityQuery query, boolean aliasRequired) {
        if (!this.shouldApply(query)) {
            return null;
        }
        StringBuilder clause = new StringBuilder();
        ArrayList clauseParams = new ArrayList();
        DocumentActivityQueryFilter filters = (DocumentActivityQueryFilter)query.getFilters();
        Stream.of(this.getActorsQuery(filters.getActors(), aliasRequired), this.getParticipantsQuery(filters.getParticipants())).filter(Objects::nonNull).forEach(userQuery -> {
            if (!clause.toString().isEmpty()) {
                clause.append(" AND ");
            }
            clause.append(userQuery.getWhereClause());
            Collections.addAll(clauseParams, userQuery.getWhereParams());
        });
        if (StringUtils.isEmpty((CharSequence)clause)) {
            return null;
        }
        return Query.select().where(clause.toString(), clauseParams.toArray());
    }

    private Query getActorsQuery(List<String> actors, boolean aliasRequired) {
        if (actors != null) {
            StringBuilder clause = new StringBuilder();
            if (actors.removeIf(WorkflowsFeatureManagerImpl::isWorkflowsUser)) {
                actors.addAll(Arrays.asList("com.comalatech.workflow", "com.comalatech.cloud.approvals", "com.comalatech.workflow.approvals"));
            }
            String placeHolder = actors.stream().map(s -> "?").collect(Collectors.joining(","));
            clause.append(aliasRequired ? "activity." : "").append("ACTOR_ID").append(" IN (").append(StringUtils.isEmpty((CharSequence)placeHolder) ? "'NO_ACTOR'" : placeHolder).append(")");
            return Query.select().where(clause.toString(), actors.toArray());
        }
        return null;
    }

    private Query getParticipantsQuery(List<String> participantIds) {
        if (Objects.isNull(participantIds) || participantIds.isEmpty()) {
            return null;
        }
        StringBuilder clause = new StringBuilder(" (");
        String placeHolder = participantIds.stream().map(s -> "?").collect(Collectors.joining(","));
        clause.append("detail.VALUE IN (").append(placeHolder).append(") ").append("AND ").append("detail.TYPE IN ('").append(ActionDetailType.APPROVAL_USER_ASSIGNED.getValue()).append("','").append(ActionDetailType.APPROVAL_USER_UNASSIGNED.getValue()).append("','").append(ActionDetailType.TASK_USER_ASSIGNED.getValue()).append("','").append(ActionDetailType.TASK_USER_UNASSIGNED.getValue()).append("')");
        clause.append(" )");
        return Query.select().where(clause.toString(), participantIds.toArray());
    }
}

