/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.command;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.comalatech.confluence.adhoc.command.AbstractAdhocWorkflowCommand;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;

@ReadOnlyAccessBlocked
public class MoveStateCommand
extends AbstractAdhocWorkflowCommand {
    private int position;

    @Override
    public void doWithWorkflow(Workflow workflow) throws WorkflowException {
        State state = workflow.getStatesContainer().getState(this.stateName);
        workflow.getStatesContainer().getStates().remove(state);
        if (this.position < workflow.getStatesContainer().size()) {
            workflow.getStatesContainer().getStates().add(this.position, state);
        } else {
            workflow.getStatesContainer().getStates().add(state);
        }
    }

    @Override
    public void validateWorkflow(ServiceCommandValidator validator, Workflow workflow) {
        if (this.position < 0 || this.position > workflow.getStatesContainer().size() - 1) {
            validator.addValidationError("comalatech.awp.designer.error.state.position", new Object[]{this.position});
        }
    }

    @Override
    public boolean requiresExistingState() {
        return true;
    }

    @Override
    public boolean requiresExistingTask() {
        return false;
    }

    public void setPosition(int position) {
        this.position = position;
    }
}

