/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoc.action.DesignerTab;
import com.comalatech.confluence.adhoc.action.EditWorkflowHelper;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@ReadOnlyAccessBlocked
public class EditSpaceWorkflowAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(EditSpaceWorkflowAction.class);
    protected WorkflowContainerManager workflowContainerManager;
    protected AdhocWorkflowManager adhocWorkflowManager;
    protected AdhocWorkflowDao adhocWorkflowDao;
    protected AdhocWorkflowsLicenseManager licenseManager;
    protected String workflowName;
    protected String tab;
    protected EditWorkflowHelper editWorkflowHelper;

    protected boolean isProduction() {
        return false;
    }

    protected boolean isNewWorkflow() {
        return false;
    }

    protected Workflow getWorkflow() throws WorkflowException {
        return this.workflowContainerManager.getWorkflowTemplate(this.getSpaceKey(), this.workflowName);
    }

    public String execute() throws Exception {
        try {
            Workflow workflow = this.getWorkflow();
            if (workflow != null) {
                this.editWorkflowHelper = new EditWorkflowHelper(workflow, this.getTab(), this.getSpace(), this.isProduction(), this.isNewWorkflow());
                this.editWorkflowHelper.setWorkflowMarkupBody(this.adhocWorkflowDao.getWorkflowTemplateBody(this.getSpaceKey(), this.workflowName));
                return "success";
            }
            return "error";
        }
        catch (WorkflowException e) {
            log.error(e.getMessage());
            return "error";
        }
    }

    protected DesignerTab getTab() {
        return DesignerTab.parse(this.tab);
    }

    public EditWorkflowHelper getEditWorkflowHelper() {
        return this.editWorkflowHelper;
    }

    public boolean isPermitted() {
        return super.isPermitted() && this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace());
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public void setWorkflowContainerManager(WorkflowContainerManager workflowContainerManager) {
        this.workflowContainerManager = workflowContainerManager;
    }

    public void setAdhocWorkflowManager(AdhocWorkflowManager adhocWorkflowManager) {
        this.adhocWorkflowManager = adhocWorkflowManager;
    }

    public void setAdhocWorkflowDao(AdhocWorkflowDao adhocWorkflowDao) {
        this.adhocWorkflowDao = adhocWorkflowDao;
    }

    public AdhocWorkflowsLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }
}

