/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

"use strict";

/*
 *  Message Component using AUI's Message
 *  src: https://docs.atlassian.com/aui/latest/docs/messages.html
 **/
var Messages = Backbone.View.extend({
    className: 'cml-message-wrapper',

    defaultOpt: {
        fadeout: true,
        delay: 4000
    },

    render: function () {
        return this.el;
    },

    generic: function (opt) {
        this._show('generic', opt);
    },

    error: function (opt) {
        this._show('error', opt);
    },

    warning: function (opt) {
        this._show('warning', opt);
    },

    _show: function (type, opt) {
        // ensure wrapper is added to body
        if(AJS.$('.' + this.className).length === 0) {
            AJS.$('body').append(this.render());
            this.setElement(AJS.$('.' + this.className));
        }
        
        // Create message
        opt = this._message(type, opt);

        // manually hide if fadeout=true
        if(opt.fadeout) {
            _.delay(_.bind(function(id) {
                this._hide(id);
            }, this), opt.delay, opt.id);
        }

        // bring to the top - may be hidden under AUI blanket
        this.$el.css('z-index', 99999);

    },

    _hide: function (id) {
        this.$('#' + id).fadeOut(250, function() {
            AJS.$(this).remove();
        });
    },

    _message: function (type, opt) {
        opt = this._messageOptions(opt);
        if(type) {
            AJS.messages[type]('.' + this.className, opt);
        }
        return opt;
    },

    _messageOptions: function (opt) {
        // available options for AJS.messages
        var cleanOpt = _.pick(opt, 'title', 'body', 'closeable', 'insert', 'shadowed', 'fadeout', 'delay', 'duration');
        return _.extend(this.defaultOpt, {
            id: 'cml-message-item-' + _.random(0,256)
        }, cleanOpt);
    }
});

module.exports = new Messages();