/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param.sort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.randombits.confluence.filtering.param.BaseParameter;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.support.MacroInfo;
import org.randombits.confluence.support.sorting.CreationDateComparator;
import org.randombits.confluence.support.sorting.ExactTitleComparator;
import org.randombits.confluence.support.sorting.ModificationDateComparator;
import org.randombits.confluence.support.sorting.NaturalTitleComparator;
import org.randombits.confluence.support.sorting.SpaceKeyComparator;
import org.randombits.confluence.support.sorting.SpaceNameComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortParameter<T>
extends BaseParameter<Comparator<? super T>> {
    private static final String DESC = " desc";
    private static final String ASC = " asc";
    public static final String NATURAL_TITLE = "natural title";
    public static final String EXACT_TITLE = "exact title";
    public static final String CREATION_DATE = "creation date";
    public static final String MODIFICATION_DATE = "modification date";
    public static final String SPACE_KEY = "space key";
    public static final String SPACE_NAME = "space name";
    private static final Map<String, Comparator<Object>> STANDARD_SORTS = new HashMap<String, Comparator<Object>>();
    private Map<String, Comparator<? super T>> sorts = new HashMap<String, Comparator<? super T>>();
    private List<Comparator<? super T>> defaults;

    public SortParameter(Comparator<? super T>[] defaults) {
        this(defaults != null ? Arrays.asList(defaults) : (Collection)null);
    }

    public SortParameter(Collection<Comparator<? super T>> defaults) {
        this(defaults, true);
    }

    public SortParameter(Comparator<? super T>[] defaults, boolean registerStandard) {
        this(Arrays.asList(defaults), registerStandard);
    }

    public SortParameter(Collection<Comparator<? super T>> defaults, boolean registerStandard) {
        super(null, "sort");
        if (registerStandard) {
            this.sorts.putAll(STANDARD_SORTS);
        }
        if (defaults != null) {
            this.defaults = new ArrayList<Comparator<? super T>>(defaults.size());
            this.defaults.addAll(defaults);
        }
    }

    public void registerComparator(String name, Comparator<? super T> comparator) {
        this.sorts.put(name, comparator);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Comparator<? super T> findObject(String parameter, MacroInfo info) throws ParameterException {
        ComparatorChain chain = new ComparatorChain();
        if (parameter != null) {
            String[] params = parameter.toLowerCase().split("[,;]");
            for (int i = 0; i < params.length; ++i) {
                void var5_6;
                boolean descending = false;
                params[i] = params[i].trim();
                if (params[i].endsWith(DESC)) {
                    descending = true;
                    params[i] = params[i].substring(0, params[i].length() - DESC.length());
                } else if (params[i].endsWith(ASC)) {
                    params[i] = params[i].substring(0, params[i].length() - ASC.length());
                }
                Comparator<? super T> comparator = this.sorts.get(params[i]);
                if (comparator == null) {
                    throw new ParameterException("Unsupported comparator: " + params[i]);
                }
                if (descending) {
                    ReverseComparator reverseComparator = new ReverseComparator(comparator);
                }
                chain.addComparator((Comparator)var5_6);
            }
        }
        if (chain.size() == 0) {
            if (this.defaults != null) {
                for (Comparator<? super T> comparator : this.defaults) {
                    chain.addComparator(comparator);
                }
            } else {
                return null;
            }
        }
        return chain;
    }

    public Comparator<? super T> createComparator(MacroInfo info) throws ParameterException {
        return (Comparator)this.findValue(info);
    }

    public Comparator<? super T> createComparator(String parameterValue) throws ParameterException {
        return this.findObject(parameterValue, null);
    }

    static {
        STANDARD_SORTS.put(NATURAL_TITLE, new NaturalTitleComparator());
        STANDARD_SORTS.put(EXACT_TITLE, new ExactTitleComparator());
        STANDARD_SORTS.put(CREATION_DATE, new CreationDateComparator());
        STANDARD_SORTS.put(MODIFICATION_DATE, new ModificationDateComparator());
        STANDARD_SORTS.put(SPACE_KEY, new SpaceKeyComparator());
        STANDARD_SORTS.put(SPACE_NAME, new SpaceNameComparator());
    }
}

