/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting;

import com.atlassian.confluence.util.GeneralUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.customware.confluence.reporting.Report;
import net.customware.confluence.reporting.ReportBuilder;
import net.customware.confluence.reporting.ReportException;
import net.customware.confluence.reporting.query.Query;
import net.customware.confluence.reporting.query.QueryException;
import org.apache.commons.collections.IteratorUtils;
import org.randombits.confluence.support.ServletAssistant;

public final class ReportUtils {
    private static final String ATTRIBUTES_NAME = "net.customware.confluence.reporting:attributes";

    private ReportUtils() {
    }

    public static boolean isIterable(Object value) {
        return value instanceof Iterator || value instanceof Iterable || value instanceof Enumeration || value instanceof Query || value != null && value.getClass().isArray();
    }

    public static Iterator<?> asIterator(Object value) {
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof Iterable) {
            return ((Iterable)value).iterator();
        }
        if (value instanceof Enumeration) {
            return IteratorUtils.asIterator((Enumeration)value);
        }
        if (value instanceof Query) {
            try {
                return ((Query)value).execute();
            }
            catch (QueryException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                return IteratorUtils.arrayIterator((Object[])value);
            }
            return Arrays.asList(value).iterator();
        }
        return IteratorUtils.emptyIterator();
    }

    public static Collection<?> asCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Iterable) {
            return IteratorUtils.toList(((Iterable)value).iterator());
        }
        if (value instanceof Iterator) {
            return IteratorUtils.toList((Iterator)value);
        }
        if (value instanceof Enumeration) {
            return Collections.list((Enumeration)value);
        }
        if (value instanceof Query) {
            try {
                return IteratorUtils.toList(((Query)value).execute());
            }
            catch (QueryException e) {
                return Collections.EMPTY_LIST;
            }
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                return Arrays.asList((Object[])value);
            }
            return Arrays.asList(value);
        }
        return Collections.EMPTY_LIST;
    }

    public static void appendAttribute(StringBuffer out, String name, Object value) {
        if (value != null) {
            out.append(" ").append(GeneralUtil.escapeXml((String)name)).append("='").append(GeneralUtil.escapeXml((String)value.toString())).append("'");
        }
    }

    public static void appendStyleParam(StringBuffer out, String name, String value) {
        if (value != null) {
            out.append(GeneralUtil.escapeXml((String)name)).append(": ").append(GeneralUtil.escapeXml((String)value)).append("; ");
        }
    }

    public static void appendAttribute(StringBuilder out, String name, Object value) {
        if (value != null) {
            out.append(" ").append(GeneralUtil.escapeXml((String)name)).append("='").append(GeneralUtil.escapeXml((String)value.toString())).append("'");
        }
    }

    public static void appendStyleParam(StringBuilder out, String name, String value) {
        if (value != null) {
            out.append(GeneralUtil.escapeXml((String)name)).append(": ").append(GeneralUtil.escapeXml((String)value)).append("; ");
        }
    }

    public static void setAttribute(Object context, String name, Object value) throws ReportException {
        Report<?, ?> report = ReportUtils.getReport(context);
        if (report != null) {
            report.setAttribute(name, value);
        } else {
            Map<String, Object> attributes = ReportUtils.getRequestAttributes(true);
            if (attributes != null) {
                attributes.put(name, value);
            }
        }
    }

    private static Map<String, Object> getRequestAttributes(boolean create) {
        HashMap attributes = null;
        HttpServletRequest req = ServletAssistant.getInstance().getRequest();
        if (req != null) {
            Object value = req.getAttribute(ATTRIBUTES_NAME);
            if (value instanceof Map) {
                attributes = (HashMap)value;
            }
            if (attributes == null && create) {
                attributes = new HashMap();
                req.setAttribute(ATTRIBUTES_NAME, attributes);
            }
        }
        return attributes;
    }

    private static Report<?, ?> getReport(Object context) throws ReportException {
        Report<?, ?> report = null;
        if (context instanceof Report) {
            report = (Report<?, ?>)context;
        } else if (ReportBuilder.isReporting() && ReportBuilder.getRootContent() != context) {
            report = ReportBuilder.getCurrentReport();
        }
        return report;
    }

    public static Object getAttribute(Object context, String name) throws ReportException {
        Report<?, ?> report = ReportUtils.getReport(context);
        if (report != null) {
            return report.getAttribute(name);
        }
        Map<String, Object> attributes = ReportUtils.getRequestAttributes(false);
        if (attributes != null) {
            return attributes.get(name);
        }
        return null;
    }
}

