/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.model.ActivityEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ApprovalActivity;
import com.comalatech.confluence.workflowreports.model.CommentActivity;
import com.comalatech.confluence.workflowreports.model.ModificationActivity;
import com.comalatech.confluence.workflowreports.model.ReadAckActivity;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvProcessor;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityEntryProcessor;
import com.comalatech.workflow.model.Assignment;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PageActivityCsvEntryProcessorLegacy
extends PageActivityCsvProcessor {
    protected final PageManager pageManager;
    protected final ReportDateFormatter dateFormatter;

    public PageActivityCsvEntryProcessorLegacy(PageManager pageManager, ReportDateFormatter dateFormatter, I18nResolver i18nResolver) {
        super(i18nResolver);
        this.pageManager = pageManager;
        this.dateFormatter = dateFormatter;
    }

    @Override
    public <E> void processEntry(StringBuilder builder, AbstractPage page, E entry) {
        ActivityReportEntry activityReportEntry = (ActivityReportEntry)entry;
        List<ActivityEntry> activityEntries = activityReportEntry.getActivityEntries();
        for (ActivityEntry activityEntry : activityEntries) {
            List<Activity> activities = activityEntry.getActivities();
            Collections.reverse(activities);
            for (Activity activity : activities) {
                List<String> contributors;
                String formattedDate = StringEscapeUtils.escapeCsv((String)this.dateFormatter.formatServerDateTimePrecise(activity.getDate()));
                String username = activity.getPerformer();
                builder.append(formattedDate).append(",").append(username == null ? this.getTextStatic("com.comalatech.activity.report.csvexport.anonymous") : username).append(",");
                String contributorsCommaSeparated = "";
                if (activity instanceof ModificationActivity && (contributors = ((ModificationActivity)activity).getContributorsUsernames()) != null && !contributors.isEmpty()) {
                    contributorsCommaSeparated = StringUtils.join(contributors, (String)",");
                }
                builder.append(StringEscapeUtils.escapeCsv((String)this.removeCSVInjectionCharacters(contributorsCommaSeparated))).append(",");
                builder.append(activity.getActivityKey()).append(",");
                builder.append(StringEscapeUtils.escapeCsv((String)this.removeCSVInjectionCharacters(this.getDescription(activity, activityEntry)))).append(",");
                Integer version = null;
                if (activity instanceof ModificationActivity) {
                    version = ((ModificationActivity)activity).getVersion();
                } else if (activity instanceof ApprovalActivity) {
                    version = activityEntry.getApprovalCheck().getVersion();
                } else if (activity instanceof ReadAckActivity) {
                    version = ((ReadAckActivity)activity).getVersion();
                } else if (activityEntry.getPageState() != null) {
                    version = activityEntry.getPageState().getContentVersion();
                } else if (activityEntry.getApprovalCheck() != null) {
                    version = activityEntry.getApprovalCheck().getVersion();
                }
                if (version != null) {
                    ContentEntityObject oldPage;
                    builder.append("v").append(version);
                    builder.append(",");
                    if (!this.isSkipOtherVersion() && (oldPage = this.pageManager.getOtherVersion((ContentEntityObject)page, version.intValue())) != null) {
                        builder.append(oldPage.getId());
                    }
                } else {
                    builder.append(",");
                }
                builder.append(",");
                if (activity.getComment() != null && activity.getComment().trim().length() > 0) {
                    builder.append(StringEscapeUtils.escapeCsv((String)this.removeCSVInjectionCharacters(PageActivityEntryProcessor.removeHtmlTags(activity.getComment()))));
                }
                builder.append(LINE_SEPARATOR);
            }
        }
    }

    private String removeCSVInjectionCharacters(String content) {
        if (content != null) {
            content = content.replaceFirst("^[\\+\\-\\@\\=]", "");
        }
        return content;
    }

    private String getDescription(Activity activity, ActivityEntry activityEntry) {
        String description = "";
        switch (activity.getActivityKey()) {
            case "approval": {
                description = this.getApprovalDescription(activity);
                break;
            }
            case "approval-assignment": {
                description = this.getApprovalAssignmentDescription(activity, activityEntry);
                break;
            }
            case "approval-unassignment": {
                description = this.getApprovalUnassignmentDescription(activity, activityEntry);
                break;
            }
            case "assignment": {
                description = this.getAssignmentDescription(activity, activityEntry);
                break;
            }
            case "comment": {
                description = this.getCommentDescription(activity);
                break;
            }
            case "completion": {
                description = this.getCompletionDescription(activity, activityEntry);
                break;
            }
            case "deletion": {
                description = this.getDeletionDescription(activity, activityEntry);
                break;
            }
            case "duedaterecord": {
                description = this.getDueDateRecordDescription(activity, activityEntry);
                break;
            }
            case "duedaterecordexpiry": {
                description = this.getDueDateRecordExpiryDescription(activityEntry);
                break;
            }
            case "modification": {
                description = this.getModificationDescription(activity);
                break;
            }
            case "read-ack": {
                description = this.getReadAckDescription(activity);
                break;
            }
            case "state": {
                description = this.getStateDescription(activity);
                break;
            }
            case "task": {
                description = this.getTaskDescription(activity, activityEntry);
            }
        }
        return PageActivityEntryProcessor.removeHtmlTags(description);
    }

    private String getApprovalDescription(Activity activity) {
        ApprovalActivity approvalActivity = (ApprovalActivity)activity;
        String roleName = approvalActivity.getApprover().getRole();
        if (!approvalActivity.getApprover().isApproved()) {
            if (roleName != null && roleName.length() > 0) {
                return this.getTextStatic("com.comalatech.activity.report.approval.rejected.role", new String[]{approvalActivity.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(approvalActivity.getDate()), approvalActivity.getSignatureMode(), roleName});
            }
            return this.getTextStatic("com.comalatech.activity.report.approval.rejected", new String[]{approvalActivity.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(approvalActivity.getDate()), approvalActivity.getSignatureMode()});
        }
        if (roleName != null && roleName.length() > 0) {
            return this.getTextStatic("com.comalatech.activity.report.approval.approved.role", new String[]{approvalActivity.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(approvalActivity.getDate()), approvalActivity.getSignatureMode(), roleName});
        }
        return this.getTextStatic("com.comalatech.activity.report.approval.approved", new String[]{approvalActivity.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(approvalActivity.getDate()), approvalActivity.getSignatureMode()});
    }

    private String getApprovalAssignmentDescription(Activity activity, ActivityEntry activityEntry) {
        com.comalatech.confluence.states.model.Assignment approvalAssignment = (com.comalatech.confluence.states.model.Assignment)activity;
        if (approvalAssignment.getRolename() != null && approvalAssignment.getRolename().length() > 0) {
            return this.getTextStatic("com.comalatech.activity.report.approval.assigned.role", new String[]{activityEntry.getApprovalCheck().getName(), approvalAssignment.getAssignee(), this.dateFormatter.formatServerTime(approvalAssignment.getDate()), approvalAssignment.getRolename()});
        }
        return this.getTextStatic("com.comalatech.activity.report.approval.assigned", new String[]{activityEntry.getApprovalCheck().getName(), approvalAssignment.getAssignee(), this.dateFormatter.formatServerTime(approvalAssignment.getDate())});
    }

    private String getApprovalUnassignmentDescription(Activity activity, ActivityEntry activityEntry) {
        Assignment assignment = (Assignment)((Object)activity);
        return this.getTextStatic("com.comalatech.activity.report.approval.unassigned", new String[]{activityEntry.getApprovalCheck().getName(), assignment.getAssignee(), this.dateFormatter.formatServerTime(assignment.getDate())});
    }

    private String getAssignmentDescription(Activity activity, ActivityEntry activityEntry) {
        String name = "'" + activityEntry.getPageTask().getName() + "'";
        com.comalatech.confluence.states.model.Assignment assignment = (com.comalatech.confluence.states.model.Assignment)activity;
        if (assignment.getAssignee() != null && !assignment.getAssignee().isEmpty()) {
            return this.getTextStatic("com.comalatech.activity.report.task.assigned", new String[]{name, assignment.getAssignee(), this.dateFormatter.formatServerTime(assignment.getDate())});
        }
        return this.getTextStatic("com.comalatech.activity.report.task.unassigned", new String[]{name, this.dateFormatter.formatServerTime(assignment.getDate())});
    }

    private String getDueDateRecordDescription(Activity activity, ActivityEntry activityEntry) {
        DueDateRecord dueDateRecord = (DueDateRecord)activity;
        if (activityEntry.getPageTask() != null) {
            String pageTaskName = "'" + activityEntry.getPageTask().getName() + "'";
            if (dueDateRecord.getDueDate() != null) {
                return this.getTextStatic("com.comalatech.activity.report.dueDateRecord.task", new String[]{pageTaskName, this.dateFormatter.formatExpiryDateTime(dueDateRecord.getDueDate()), this.dateFormatter.formatServerTime(dueDateRecord.getDate())});
            }
            return this.getTextStatic("com.comalatech.activity.report.dueDateRecord.task.remove", new String[]{pageTaskName, this.dateFormatter.formatServerTime(dueDateRecord.getDate())});
        }
        if (activityEntry.getApprovalCheck() != null) {
            if (dueDateRecord.getDueDate() != null) {
                return this.getTextStatic("com.comalatech.activity.report.dueDateRecord.approval", new String[]{activityEntry.getApprovalCheck().getName(), this.dateFormatter.formatExpiryDateTime(dueDateRecord.getDueDate()), this.dateFormatter.formatServerTime(activity.getDate())});
            }
            return this.getTextStatic("com.comalatech.activity.report.dueDateRecord.approval.remove", new String[]{activityEntry.getApprovalCheck().getName(), this.dateFormatter.formatServerTime(dueDateRecord.getDate())});
        }
        if (dueDateRecord.getDueDate() != null) {
            return this.getTextStatic("com.comalatech.activity.report.dueDateRecord.state", new String[]{activityEntry.getPageState().getName(), this.dateFormatter.formatExpiryDateTime(dueDateRecord.getDueDate()), this.dateFormatter.formatServerTime(activity.getDate())});
        }
        return this.getTextStatic("com.comalatech.activity.report.dueDateRecord.state.remove", new String[]{activityEntry.getPageState().getName(), this.dateFormatter.formatServerTime(dueDateRecord.getDate())});
    }

    private String getStateDescription(Activity activity) {
        PageState pageState = (PageState)activity;
        StringBuilder description = new StringBuilder();
        if (pageState.getLastAssignment() != null) {
            description.append(this.getTextStatic("com.comalatech.activity.report.changed-state.assigned", new String[]{pageState.getState(), ((com.comalatech.confluence.states.model.Assignment)pageState.getLastAssignment()).getAssignee(), this.dateFormatter.formatServerTime(activity.getDate())}));
        } else {
            description.append(this.getTextStatic("com.comalatech.activity.report.changed-state", new String[]{pageState.getState(), this.dateFormatter.formatServerTime(activity.getDate())}));
        }
        if (pageState.getStateChangeReason() != null) {
            description.append(" (").append(this.getTextStatic(pageState.getStateChangeReason().getI18nName())).append(")");
        }
        return description.toString();
    }

    private String getModificationDescription(Activity activity) {
        ModificationActivity modification = (ModificationActivity)activity;
        if (modification.isCreation()) {
            return this.getTextStatic("com.comalatech.activity.report.created", new String[]{this.dateFormatter.formatServerTime(activity.getDate())});
        }
        return this.getTextStatic("com.comalatech.activity.report.modified", new String[]{this.dateFormatter.formatServerTime(activity.getDate())});
    }

    private String getTaskDescription(Activity activity, ActivityEntry activityEntry) {
        PageTask pageTask = (PageTask)activity;
        String taskName = "'" + pageTask.getName() + "'";
        if (pageTask.getType().isQuestion()) {
            String activityUsers = "";
            List<String> users = activityEntry.getActivityUsers();
            if (users != null && !users.isEmpty()) {
                activityUsers = String.join((CharSequence)" ", users);
            }
            return this.getTextStatic("com.comalatech.activity.report.task.question-asked", new String[]{taskName, activityUsers, this.dateFormatter.formatServerTime(pageTask.getDate())});
        }
        return this.getTextStatic("com.comalatech.activity.report.task.created", new String[]{taskName, this.dateFormatter.formatServerTime(pageTask.getDate())});
    }

    private String getDueDateRecordExpiryDescription(ActivityEntry activityEntry) {
        if (activityEntry.getPageTask() != null) {
            String pageTaskName = "'" + activityEntry.getPageTask().getName() + "'";
            return this.getTextStatic("com.comalatech.activity.report.dueDateRecord.task.expired", new String[]{pageTaskName});
        }
        return this.getTextStatic("com.comalatech.activity.report.dueDateRecord.approval.expired", new String[]{activityEntry.getApprovalCheck().getName()});
    }

    private String getCompletionDescription(Activity activity, ActivityEntry activityEntry) {
        TaskCompletion taskCompletion = (TaskCompletion)activity;
        PageTask pageTask = activityEntry.getPageTask();
        return this.getTextStatic("com.comalatech.activity.report.task.completed", new String[]{"'" + pageTask.getName() + "'", this.dateFormatter.formatServerTime(taskCompletion.getDate())});
    }

    private String getCommentDescription(Activity activity) {
        CommentActivity commentActivity = (CommentActivity)activity;
        return this.getTextStatic("com.comalatech.activity.report.task.commented", new String[]{this.dateFormatter.formatServerTime(commentActivity.getDate())});
    }

    private String getReadAckDescription(Activity activity) {
        return this.getTextStatic("readack.activity.report.confirmed.description", new String[]{this.dateFormatter.formatServerTime(activity.getDate())});
    }

    private String getDeletionDescription(Activity activity, ActivityEntry activityEntry) {
        return this.getTextStatic("com.comalatech.activity.report.task.deleted", new String[]{"'" + activityEntry.getPageTask().getName() + "'", this.dateFormatter.formatServerTime(activity.getDate())});
    }
}

