/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.ConfluenceRendererConfiguration;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RendererConfiguration;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.spring.container.ContainerManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.confluence.workflow.macros.templates.NoBodyBaseMacro;
import com.comalatech.confluence.workflow.stats.TrackedPluginsEnum;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowreports.WorkflowReportManager;
import com.comalatech.confluence.workflowreports.model.TasksReportFilter;
import com.comalatech.confluence.workflowreports.model.WorkflowReport;
import com.comalatech.confluence.workflowreports.model.WorkflowReportOptions;
import com.comalatech.confluence.workflowreports.model.WorkflowReportSortEnum;
import com.comalatech.workflow.template.LinkedTemplateManager;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;

public class WorkflowReportMacro
extends NoBodyBaseMacro
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WorkflowReportMacro.class);
    private static final String[] SPACEKEY_PARAM = new String[]{"space", "spacekey", "spaces", "spacekeys"};
    private static final String[] MAXENTRIES_PARAM = new String[]{"entries", "max", "maxentries"};
    private static final String[] STATE_PARAM = new String[]{"state", "states"};
    private static final String[] APPROVAL_PARAM = new String[]{"approval", "approvalname"};
    private static final String STATES_TEMPLATE = "/templates/reports/states-report.vm";
    private static final String DASHBOARD_TEMPLATE = "/templates/reports/dashboard-report.vm";
    private static final String TASKS_TEMPLATE = "/templates/reports/tasks-report.vm";
    private static final String APPROVALS_TEMPLATE = "/templates/reports/approvals-report.vm";
    private static final String STATS_TEMPLATE = "/templates/reports/stats-report.vm";
    private static final String[] FILTER_PARAM = new String[]{"filter", "filters"};
    private static final String TYPE_PARAM = "type";
    private static final String SORT_PARAM = "sort";
    private static final String ORDER_PARAM = "order";
    private static final String PARENT_PARAM = "parent";
    private static final String USER_PARAM = "user";
    private static final String APPROVER_PARAM = "approver";
    private static final String[] ASSIGNEE_PARAM = new String[]{"assigned", "assignee"};
    private static final String[] HIDEHDEADER_PARAM = new String[]{"hideheader", "hideHeader", "hide"};
    private WorkflowReportManager workflowReportManager;
    private WorkflowContainerManager workflowContainerManager;
    private LinkedTemplateManager linkedTemplateManager;
    private PageManager pageManager;
    private WorkflowsFeatureManager workflowsFeatureManager;
    private RendererConfiguration rendererConfiguration;
    private PluginAccessor pluginAccessor;
    private ServletActionContextCompatManager servletActionContextCompatManager;
    private static final String[] LABELS_PARAM = new String[]{"label", "labels"};

    public void afterPropertiesSet() throws Exception {
        if (this.rendererConfiguration == null) {
            this.rendererConfiguration = (RendererConfiguration)ComponentLocator.getComponent(ConfluenceRendererConfiguration.class);
            if (this.rendererConfiguration == null) {
                this.rendererConfiguration = (ConfluenceRendererConfiguration)ContainerManager.getComponent((String)"rendererConfiguration");
            }
        }
    }

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        Parameters params;
        try {
            params = new Parameters(parameters, renderContext);
        }
        catch (MacroException me) {
            return this.renderErrorMessage(ConfluenceActionSupport.getTextStatic((String)(this.workflowsFeatureManager.getPluginKey() + ".workflowreport.error.params.heading")), me.getMessage());
        }
        HttpServletRequest request = this.servletActionContextCompatManager.getRequest();
        Map reqParams = request == null ? Maps.newHashMap() : request.getParameterMap();
        WorkflowReportOptions options = params.getOptions();
        if (options.isPageReport()) {
            throw new MacroException("ERROR type=page not supported");
        }
        if (options.isDashboardReport() && !TextUtils.stringSet((String)options.getUserName())) {
            if (log.isDebugEnabled()) {
                log.debug("Workflow report macro: anonymous user rendering dashboard report");
            }
            return "";
        }
        this.addRequestOptions(options, reqParams);
        WorkflowReport report = this.workflowReportManager.createReport(options, new PaginationSupport(options.getMaxEntries()));
        if (params.page != null && !this.hasRefinedPluginAndSpace(params)) {
            report.setUrl(this.rendererConfiguration.getWebAppContextPath() + params.page.getUrlPath());
        } else {
            report.setUrl(request.getRequestURI());
        }
        if (options.isDashboardReport()) {
            return this.renderReport(params, report, DASHBOARD_TEMPLATE);
        }
        if (options.isTasksReport()) {
            return this.renderReport(params, report, TASKS_TEMPLATE);
        }
        if (options.isStatsReport()) {
            return this.renderReport(params, report, STATS_TEMPLATE);
        }
        if (report.getStatesNames() != null) {
            return this.renderReport(params, report, STATES_TEMPLATE);
        }
        return this.renderReport(params, report, APPROVALS_TEMPLATE);
    }

    private boolean hasRefinedPluginAndSpace(Parameters params) {
        boolean refinedWikiPluginEnabled = this.pluginAccessor.isPluginEnabled(TrackedPluginsEnum.REFINEDWIKI_THEME.getKey());
        boolean rWPluginParamsPageSpaceKey = params.page != null && params.page.getSpaceKey().equals("rwlayoutkey");
        return refinedWikiPluginEnabled && rWPluginParamsPageSpaceKey;
    }

    protected String renderErrorMessage(String header, String message) {
        return "<div class=\"aui-message aui-message-error\">\n    <p class=\"title\">\n        <strong>" + header + "</strong>\n    </p>\n    <p>" + StringEscapeUtils.escapeHtml((String)message) + "</p>\n</div>\n";
    }

    private void addRequestOptions(WorkflowReportOptions options, Map<String, String[]> reqParams) {
        if (options.isTasksReport()) {
            String[] taskFilterType = reqParams.get(QUERY_PARAMS.TASKS_FILTER_QUERY_PARAM.getName());
            TasksReportFilter filter = TasksReportFilter.parse(taskFilterType == null ? "" : taskFilterType[0]);
            options.setTasksFilter(filter == null ? TasksReportFilter.getDefault() : filter);
            String[] assignee = reqParams.get(QUERY_PARAMS.ASSIGNEE_FILTER_QUERY_PARAM.getName());
            if (assignee != null) {
                options.setAssignee(assignee[0]);
            }
        }
    }

    private String renderReport(Parameters params, WorkflowReport workflowReport, String template) throws MacroException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("workflowReport", workflowReport);
        if (template.equals(DASHBOARD_TEMPLATE) && !workflowReport.getUrl().contains("getDashboardLine.action")) {
            context.put("showPagination", true);
        }
        return this.renderTemplate(context, template);
    }

    public void setWorkflowReportManager(WorkflowReportManager workflowReportManager) {
        this.workflowReportManager = workflowReportManager;
    }

    public void setWorkflowContainerManager(WorkflowContainerManager workflowContainerManager) {
        this.workflowContainerManager = workflowContainerManager;
    }

    public void setLinkedTemplateManager(LinkedTemplateManager linkedTemplateManager) {
        this.linkedTemplateManager = linkedTemplateManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void setRendererConfiguration(RendererConfiguration rendererConfiguration) {
        this.rendererConfiguration = rendererConfiguration;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setServletActionContextCompatManager(@Qualifier(value="servletActionContextCompat") ServletActionContextCompatManager servletActionContextCompatManager) {
        this.servletActionContextCompatManager = servletActionContextCompatManager;
    }

    private class Parameters
    extends MacroParameters {
        private final AbstractPage page;
        private final WorkflowReportOptions options;

        public Parameters(Map parameters, RenderContext renderContext) throws MacroException {
            String filter;
            super(parameters, renderContext);
            this.page = renderContext instanceof PageContext && this.getAbstractPage() != null ? this.getAbstractPage().getLatestVersion() : null;
            String type = this.get(WorkflowReportMacro.TYPE_PARAM);
            boolean dashboard = "dashboard".equalsIgnoreCase(type);
            String stateName = this.get(STATE_PARAM);
            String approvalName = this.get(APPROVAL_PARAM);
            String spaceKey = this.get(SPACEKEY_PARAM);
            if (!TextUtils.stringSet((String)spaceKey) && !dashboard && this.page != null) {
                spaceKey = this.page.getSpaceKey();
            }
            String userName = this.getUserParam(WorkflowReportMacro.USER_PARAM);
            int maxEntries = this.getInt(MAXENTRIES_PARAM, 20);
            if (maxEntries > 500) {
                maxEntries = 500;
            }
            this.options = new WorkflowReportOptions(spaceKey, this.page != null ? this.page.getSpaceKey() : null, this.getSort(parameters), maxEntries);
            if (!(this.options.getSpaceKey() != null || dashboard || TextUtils.stringSet((String)stateName) || TextUtils.stringSet((String)approvalName))) {
                throw new MacroException(ConfluenceActionSupport.getTextStatic((String)(WorkflowReportMacro.this.workflowsFeatureManager.getPluginKey() + ".workflowreport.error.params.noSpaceKey")));
            }
            if (TextUtils.stringSet((String)stateName)) {
                this.options.setStateNames(stateName);
            } else if (TextUtils.stringSet((String)approvalName)) {
                filter = this.get(FILTER_PARAM, "pending");
                this.options.setApprovalFilter(filter, approvalName);
                this.options.setApprovalsReport(true);
            }
            if ("states".equalsIgnoreCase(type)) {
                this.options.setStatesReport(true);
            } else if ("approvals".equalsIgnoreCase(type)) {
                this.options.setApprovalsReport(true);
            } else if ("page".equalsIgnoreCase(type)) {
                this.options.setPageReport(true);
            } else if ("stats".equalsIgnoreCase(type)) {
                this.options.setStatsReport(true);
            } else if ("tasks".equalsIgnoreCase(type)) {
                this.options.setTasksReport(true);
            } else if (dashboard) {
                this.options.setDashboardReport(true);
            } else {
                this.options.setStatesReport(true);
            }
            if (this.options.isDashboardReport() && !TextUtils.stringSet((String)userName)) {
                userName = AuthenticatedUserThreadLocal.getUsername();
            }
            if (this.options.isStatsReport()) {
                this.setStates();
            }
            if (this.options.isStatesReport()) {
                filter = this.get(FILTER_PARAM);
                this.options.setFilters(filter);
            }
            this.options.setParentId(this.getParentParam());
            this.options.setUserName(userName);
            this.options.setApproverName(this.getUserParam(WorkflowReportMacro.APPROVER_PARAM));
            this.options.setAssignee(this.getUserParam(ASSIGNEE_PARAM));
            this.options.setHideHeader(this.getFlag(HIDEHDEADER_PARAM, false));
            this.setLabels();
        }

        private void setStates() {
            String spaceKey = this.options.getSpaceKey();
            List<Workflow> workflows = WorkflowReportMacro.this.workflowContainerManager.getAllProductionWorkflows(spaceKey);
            List<com.comalatech.workflow.model.Workflow> linkedWorkflows = WorkflowReportMacro.this.linkedTemplateManager.getLinkedTemplates(spaceKey);
            for (com.comalatech.workflow.model.Workflow workflow : linkedWorkflows) {
                workflows.add((Workflow)workflow);
            }
            HashSet<String> stateNamesSet = new HashSet<String>();
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (Workflow workflow : workflows) {
                if (workflow.getStatesContainer() == null) continue;
                for (State state : workflow.getStatesContainer().getStates()) {
                    if (stateNamesSet.contains(state.getName())) continue;
                    stateNamesSet.add(state.getName());
                    sb.append(separator).append(state.getName());
                    separator = ",";
                }
            }
            this.options.setStateNames(sb.toString());
        }

        private void setLabels() throws MacroException {
            String[] labels;
            String labelNames = this.get(LABELS_PARAM);
            if (labelNames == null) {
                return;
            }
            if (labelNames.startsWith("&")) {
                this.options.setMustHaveAllLabels(true);
                labelNames = labelNames.substring(1);
            }
            for (String label : labels = MiscUtils.splitAndTrim(labelNames)) {
                ParsedLabelName parsedLabel = LabelParser.parse((String)label);
                if (parsedLabel == null) {
                    throw new MacroException(ConfluenceActionSupport.getTextStatic((String)(WorkflowReportMacro.this.workflowsFeatureManager.getPluginKey() + ".workflowreport.error.params.invalidLabel"), (Object[])new String[]{HtmlUtil.htmlEncode((String)label)}));
                }
                this.options.addLabel(parsedLabel.toLabel());
            }
        }

        private String getParentParam() throws MacroException {
            String parent = this.get(WorkflowReportMacro.PARENT_PARAM);
            if (parent == null) {
                return parent;
            }
            if (parent.toLowerCase().startsWith("@self")) {
                return this.getPage().getIdAsString();
            }
            Page parentPage = WorkflowReportMacro.this.pageManager.getPage(this.options.getSpaceKey(), parent);
            if (parentPage != null) {
                return parentPage.getIdAsString();
            }
            throw new MacroException(ConfluenceActionSupport.getTextStatic((String)(WorkflowReportMacro.this.workflowsFeatureManager.getPluginKey() + ".workflowreport.error.params.invalidPageName"), (Object[])new String[]{HtmlUtil.htmlEncode((String)parent)}));
        }

        private WorkflowReportSortEnum getSort(Map parameters) throws MacroException {
            String order;
            String reportType = parameters.containsKey(WorkflowReportMacro.TYPE_PARAM) ? parameters.get(WorkflowReportMacro.TYPE_PARAM).toString() : "states";
            String sort = parameters.containsKey(WorkflowReportMacro.SORT_PARAM) ? parameters.get(WorkflowReportMacro.SORT_PARAM).toString() : WorkflowReportSortEnum.MODIFIED_DESCENDING.getField();
            String string = order = parameters.containsKey(WorkflowReportMacro.ORDER_PARAM) ? "ascending" : "descending";
            if (TextUtils.stringSet((String)sort)) {
                if (sort.equals("pagestate")) {
                    sort = "pagestateName";
                } else if ("tasks".equals(reportType) && sort.equals("duedate")) {
                    sort = "earliestTaskDueDate";
                } else if ("states".equals(reportType) && sort.equals("duedate")) {
                    sort = "nextexpiration";
                }
            }
            return WorkflowReportSortEnum.makeSort(sort, order);
        }

        private String getUserParam(String paramName) throws MacroException {
            return this.getResolvedUser(this.get(paramName));
        }

        private String getUserParam(String[] paramName) throws MacroException {
            return this.getResolvedUser(this.get(paramName));
        }

        private String getResolvedUser(String user) throws MacroException {
            if (user == null) {
                return null;
            }
            if (user.startsWith("@")) {
                if (user.toLowerCase().contains("self")) {
                    return AuthenticatedUserThreadLocal.getUsername();
                }
                throw new MacroException(ConfluenceActionSupport.getTextStatic((String)(WorkflowReportMacro.this.workflowsFeatureManager.getPluginKey() + ".workflowreport.error.params.userName"), (Object[])new String[]{HtmlUtil.htmlEncode((String)user)}));
            }
            return user.trim();
        }

        public WorkflowReportOptions getOptions() {
            return this.options;
        }
    }

    private static enum QUERY_PARAMS {
        TASKS_FILTER_QUERY_PARAM("taskFilter"),
        ASSIGNEE_FILTER_QUERY_PARAM("assignee");

        private final String name;

        private QUERY_PARAMS(String name) {
            this.name = name;
        }

        private String getName() {
            return this.name;
        }
    }
}

