/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.messaging.Message;
import com.comalatech.confluence.messaging.PageMessageManager;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.states.model.StateSubmission;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.StateSelectionManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStateSelectionManager
implements StateSelectionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultStateSelectionManager.class);
    private final PageMessageManager pageMessageManager;

    public DefaultStateSelectionManager(PageMessageManager pageMessageManager) {
        this.pageMessageManager = pageMessageManager;
    }

    @Override
    public StateSelection getStatesSelection(PageWorkflows pageWorkflows, boolean adminOverride) {
        List<Object> selectableStates = new ArrayList();
        boolean dueDate = false;
        boolean adhoc = false;
        ValueStore valueStore = pageWorkflows.getValueStore();
        AbstractPage page = valueStore.getPage();
        StatesContainer statesContainer = pageWorkflows.getStatesContainer();
        PageState currentPageState = valueStore.getPageState();
        if (statesContainer == null) {
            return null;
        }
        State currentState = currentPageState == null ? statesContainer.getInitialState() : statesContainer.getState(currentPageState.getState());
        if (currentState == null) {
            log.info(page + " is on an unknown state. Created selection to workflow's initial state");
            return new StateSelection(Collections.singletonList(statesContainer.getInitialState()), false);
        }
        if (adminOverride) {
            List<State> states = statesContainer.getStates();
            if (states.size() > 0) {
                selectableStates = states;
            }
        } else {
            selectableStates = new ArrayList();
            HashSet<String> stateNames = new HashSet<String>();
            stateNames.add(currentState.getName());
            for (StateSelection stateSelection : currentState.getStateSelections()) {
                try {
                    if (!stateSelection.evaluate(valueStore)) continue;
                    if (stateSelection.isAdhoc()) {
                        adhoc = true;
                    }
                    if (stateSelection instanceof StateSubmission) {
                        return stateSelection;
                    }
                    for (State allowedState : stateSelection.getAllowedStates()) {
                        boolean bl = dueDate = dueDate || allowedState.getDueDateTimer() != null && allowedState.getDueDateTimer().isSelectable();
                        if (stateNames.contains(allowedState.getName())) continue;
                        stateNames.add(allowedState.getName());
                        selectableStates.add(allowedState);
                    }
                }
                catch (WorkflowUserException e) {
                    log.error(e.getMessage());
                    this.logMessage(page, e.getMessage());
                }
                catch (WorkflowException e) {
                    log.error("", (Throwable)e);
                    this.logMessage(page, e.getMessage());
                }
            }
            if (currentState.isAssignable() && !currentState.isHideSelection() && (currentPageState.getLastAssignment() == null || ((Activity)((Object)currentPageState.getLastAssignment())).getPerformer().equals(AuthenticatedUserThreadLocal.getUsername()))) {
                selectableStates.add(0, currentState);
            }
        }
        if (selectableStates.size() == 0) {
            return null;
        }
        StateSelection selection = new StateSelection(selectableStates, adhoc);
        selection.setSelectDueDate(dueDate);
        selection.setPageAssignable(currentState.isAssignable());
        return selection;
    }

    private void logMessage(AbstractPage page, String message) {
        this.pageMessageManager.setMessage(page, "Workflow Error", AuthenticatedUserThreadLocal.get(), "Error in states selection: " + message, Message.MacroParamStyle.WARNING.param, 20L);
    }
}

