/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.DefaultValueStore;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.SelectorManager;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.workflow.model.Selectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultSelectorManager
implements SelectorManager,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultSelectorManager.class);
    private static final String[] EMPTY = new String[0];
    private final UsersListResolver usersListResolver;
    private final InternalWorkflowParameterManager workflowParameterManager;
    private ApprovalManager approvalManager;
    private ApplicationContext applicationContext;

    public DefaultSelectorManager(UsersListResolver usersListResolver, InternalWorkflowParameterManager workflowParameterManager) {
        this.usersListResolver = usersListResolver;
        this.workflowParameterManager = workflowParameterManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.approvalManager = (ApprovalManager)this.applicationContext.getBean("approvalManager", ApprovalManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public String[] getRequiredUsersNames(Selector selector, ValueStore valueStore) throws WorkflowException {
        if (selector != null) {
            ApprovalCheck approvalCheck = this.approvalManager.getLastApprovalByName(valueStore, selector.getApprovalName(), true);
            if (approvalCheck != null) {
                return approvalCheck.getRequiredApprovers();
            }
            if (selector.isAllMustApprove()) {
                return this.usersListResolver.getValueAsUserNames(valueStore, valueStore.getPage(), selector.getUsers(), true);
            }
        }
        return EMPTY;
    }

    @Override
    public Selectable.Selector makeUiSelector(final Selector selector, final ValueStore valueStore) throws WorkflowException {
        if (selector == null) {
            return null;
        }
        UsersListResolver.UserGroupResolved userGroupResolved = this.usersListResolver.getUsersGroupsResolved(valueStore, valueStore.getPage(), selector.getUsers(), true);
        final ArrayList<ConfluenceUser> finalUsersNames = new ArrayList<ConfluenceUser>(userGroupResolved.getUsersOnlyMap().values());
        final ArrayList<Group> finalGroupNames = new ArrayList<Group>(userGroupResolved.getGroupsOnlyMap().values());
        return new Selectable.Selector(){

            @Override
            public List<ConfluenceUser> getUsers() {
                return finalUsersNames;
            }

            @Override
            public List<Group> getGroups() {
                return finalGroupNames;
            }

            @Override
            public int getMinAssignees() {
                if (selector.isSelectOne()) {
                    return 1;
                }
                if (StringUtils.isNumeric((String)selector.getMinimum())) {
                    return Integer.parseInt(selector.getMinimum());
                }
                try {
                    return Double.valueOf(valueStore.getValue(selector.getMinimum())).intValue();
                }
                catch (WorkflowException | NumberFormatException ex) {
                    log.error("Value of the value reference used to set the minimum approvers in '" + selector.getApprovalName() + "' approval, named '" + DefaultValueStore.parseValueReferenceIntoName(selector.getMinimum()) + "', is not a number.", (Throwable)ex);
                    if (selector.getType() == 0) {
                        return 0;
                    }
                    return 1;
                }
            }

            @Override
            public int getMaxAssignees() {
                return 100;
            }

            @Override
            public boolean isFixed() {
                return selector.isAllMustApprove();
            }

            @Override
            public boolean isOneApproverOnly() {
                return selector.isSelectOne();
            }
        };
    }

    @Override
    public Collection<Entity> getSelectableUsersOrGroups(Selector selector, ValueStore valueStore) throws WorkflowException {
        if (selector == null || selector.isAllMustApprove()) {
            return Collections.emptyList();
        }
        return this.usersListResolver.getValueAsUsersOrGroups(valueStore, selector.getUsers());
    }

    @Override
    public ConfluenceUser[] getSelectableUsers(ValueStore valueStore, Selector selector, boolean ignoreExceptions) throws WorkflowException {
        return this.usersListResolver.getValueAsUsers(valueStore, valueStore.getPage(), selector.getUsers(), ignoreExceptions);
    }

    @Override
    public String[] getSelectedApprovers(AbstractPage page, String approvalName) {
        String usersNames = this.workflowParameterManager.getParameterValue(page, approvalName + "selection");
        if (usersNames == null) {
            return EMPTY;
        }
        return MiscUtils.splitAndTrim(usersNames);
    }
}

