/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

public class PageReference {
    private String spaceKey;
    private String pageName;
    private String attribute;

    private PageReference(String pageName) {
        this.pageName = pageName;
    }

    private PageReference(String spaceKey, String pageName, String attribute) {
        this.spaceKey = spaceKey;
        this.pageName = pageName;
        this.attribute = attribute;
    }

    public static PageReference parse(String reference) {
        String valueName = null;
        int nameix = reference.indexOf(":");
        if (nameix < 0) {
            return new PageReference(reference);
        }
        if (nameix != 0 && reference.length() != 1) {
            String pageTitle;
            String spaceKey;
            int ix = reference.indexOf(58, nameix + 1);
            if (ix < nameix) {
                spaceKey = reference.substring(0, nameix);
                pageTitle = reference.substring(nameix + 1);
            } else {
                spaceKey = reference.substring(0, nameix);
                pageTitle = reference.substring(nameix + 1, ix);
                if (reference.length() > ix + 1) {
                    valueName = reference.substring(ix + 1);
                }
            }
            return new PageReference(spaceKey, pageTitle, valueName);
        }
        return new PageReference(null, null, null);
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.spaceKey != null) {
            sb.append(this.spaceKey).append(':');
        }
        sb.append(this.pageName);
        if (this.attribute != null) {
            sb.append(':').append(this.attribute);
        }
        return sb.toString();
    }
}

