/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.state;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.model.PageState;
import java.util.Date;

public class StateExpiredMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public StateExpiredMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) {
        if (event instanceof StateExpireEvent) {
            StateExpireEvent stateExpireEvent = (StateExpireEvent)event;
            return this.buildActivity(stateExpireEvent.getAbstractPage(), stateExpireEvent.getState(), stateExpireEvent.getTimestamp());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, long timestamp) {
        Actor actor = this.actorUtils.buildWorkflowActor();
        ActionDetails details = new ActionDetails();
        details.addAll(this.buildStateActionDetails(state));
        Date expiredDate = state.getExpirationDate();
        if (expiredDate != null) {
            details.addDetail(ActionDetailType.NEW_EXPIRY_DATE, String.valueOf(expiredDate.getTime()));
        }
        Action action = new Action(new ActionType(ActionType.Type.STATE, ActionType.Subtype.STATE_EXPIRED), actor, details);
        return new Activity(StateExpiredMapper.buildTarget((ContentEntityObject)abstractPage), timestamp, action);
    }
}

