/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model;

import com.comalatech.confluence.workflow.restv2.model.RestInstructions;
import com.comalatech.confluence.workflow.restv2.model.RestParameter;
import com.comalatech.confluence.workflow.restv2.model.RestReadAck;
import com.comalatech.confluence.workflow.restv2.model.RestState;
import com.comalatech.confluence.workflow.restv2.model.RestTrigger;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflowSection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="restWorkflow")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
public class RestWorkflow {
    public String key;
    public String name;
    public String description;
    public String blueprintKey;
    public String css;
    public Boolean active;
    public Boolean adhoc;
    public String adminUsers;
    public Boolean displayProgressTracker;
    public Boolean updateStatus;
    public HideStatus hideStatus;
    public Boolean hideStates;
    public String tip;
    public TaskMode taskMode;
    public List<ContentType> contentTypes;
    public List<String> labels;
    public List<String> stickyLabels;
    public Boolean invertLabels;
    public RestWorkflowSection pageHeader;
    public RestWorkflowSection pageFooter;
    public RestInstructions instructions;
    public List<RestParameter> parameters;
    public List<RestState> states;
    public RestReadAck readAck;
    public List<RestTrigger> triggers;
    public String blobTriggers;
    public Boolean pageReadConfirmation;

    public RestWorkflow() {
    }

    public RestWorkflow(String key, String name, String description, String blueprintKey, String css, Boolean active, Boolean adhoc, String adminUsers, Boolean displayProgressTracker, Boolean updateStatus, HideStatus hideStatus, Boolean hideStates, String tip, TaskMode taskMode, List<ContentType> contentTypes, List<String> labels, List<String> stickyLabels, Boolean invertLabels, RestWorkflowSection pageHeader, RestWorkflowSection pageFooter, RestInstructions instructions, List<RestParameter> parameters, List<RestState> states, RestReadAck readAck, List<RestTrigger> triggers, String blobTriggers, Boolean pageReadConfirmation) {
        this.key = key;
        this.name = name;
        this.description = description;
        this.blueprintKey = blueprintKey;
        this.css = css;
        this.active = active;
        this.adhoc = adhoc;
        this.adminUsers = adminUsers;
        this.displayProgressTracker = displayProgressTracker;
        this.updateStatus = updateStatus;
        this.hideStatus = hideStatus;
        this.hideStates = hideStates;
        this.tip = tip;
        this.taskMode = taskMode;
        this.contentTypes = contentTypes;
        this.labels = labels;
        this.stickyLabels = stickyLabels;
        this.invertLabels = invertLabels;
        this.pageHeader = pageHeader;
        this.pageFooter = pageFooter;
        this.instructions = instructions;
        this.parameters = parameters;
        this.states = states;
        this.readAck = readAck;
        this.triggers = triggers;
        this.blobTriggers = blobTriggers;
        this.pageReadConfirmation = pageReadConfirmation;
    }

    @XmlType(name="workflowContentType")
    @XmlEnum
    public static enum ContentType {
        PAGE("page"),
        BLOGPOST("blogpost");

        private static Map<String, ContentType> FORMAT_MAP;
        private final String formatted;

        private ContentType(String formatted) {
            this.formatted = formatted;
        }

        @JsonValue
        public String toString() {
            return this.formatted;
        }

        @JsonCreator
        public static ContentType fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        static {
            FORMAT_MAP = Stream.of(ContentType.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }

    public static enum TaskMode {
        DEFAULT("default"),
        STRICT("strict"),
        LENIENT("lenient");

        private static Map<String, TaskMode> FORMAT_MAP;
        private final String formatted;

        private TaskMode(String formatted) {
            this.formatted = formatted;
        }

        @JsonValue
        public String toString() {
            return this.formatted;
        }

        @JsonCreator
        public static TaskMode fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        static {
            FORMAT_MAP = Stream.of(TaskMode.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }

    public static enum HideStatus {
        SHOW("show"),
        HIDE("hide"),
        READ_ONLY("read_only");

        private static Map<String, HideStatus> FORMAT_MAP;
        private final String formatted;

        private HideStatus(String formatted) {
            this.formatted = formatted;
        }

        @JsonValue
        public String toString() {
            return this.formatted;
        }

        @JsonCreator
        public static HideStatus fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        static {
            FORMAT_MAP = Stream.of(HideStatus.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }
}

