/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.AbstractUserCondition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCondition
extends AbstractUserCondition {
    private static final Logger log = LoggerFactory.getLogger(UserCondition.class);

    public UserCondition(boolean not, String userList) {
        super(not, userList);
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("user", (Object)((this.not ? "!" : "") + MiscUtils.stringListToCommaSeparatedList(this.getUserNames(), ",")));
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        UsersListResolver.UserGroupResolved usersGroupsResolved = this.getUsersListResolver().getUsersGroupsResolved(valueStore, valueStore.getPage(), String.join((CharSequence)",", this.userNames), true);
        ConfluenceUser authUser = this.getUser();
        for (ConfluenceUser userToCheck : usersGroupsResolved.getUsersOnly()) {
            if (!(userToCheck == null ? authUser == null : authUser != null && authUser.getName().equals(userToCheck.getName()))) continue;
            return true;
        }
        if (usersGroupsResolved.getGroupsOnly().size() > 0 && authUser != null) {
            for (Group group : usersGroupsResolved.getGroupsOnly()) {
                try {
                    if (!this.getGroupManager().hasMembership(group, (User)authUser)) continue;
                    return true;
                }
                catch (EntityException e) {
                    log.error("There has been an error checking the membership of the authUser {}: {}", (Object)authUser, (Object)e.getMessage());
                }
            }
        }
        return false;
    }

    @Override
    public String toString(ValueStore valueStore) {
        StringBuffer sb = new StringBuffer("user is ");
        if (this.not) {
            sb.append("not ");
        }
        sb.append(this.makeNiceUsersList(valueStore));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserCondition)) {
            return false;
        }
        UserCondition c = (UserCondition)o;
        return this.not == c.not && Arrays.equals(this.getUserNames(), c.getUserNames());
    }
}

