/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.states.model.Timer;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Period;
import org.joda.time.format.DateTimeFormatter;

public class DueDateWorkflowElement
extends WorkflowElement {
    public static final String DUEDATE = "duedate";
    public static final String DUEDATE_CAMEL = "dueDate";
    public static final DateTimeFormatter DUE_DATE_FORMATTER = TimerUtils.ALT_FORMAT3;
    protected List<Timer> timers = new ArrayList<Timer>();

    protected DueDateWorkflowElement(List<Condition> conditions) {
        super(conditions);
    }

    public void setDueDate(String dueDate) throws MacroException {
        if (StringUtils.isBlank((String)dueDate)) {
            return;
        }
        if (dueDate.contains("@")) {
            this.setDueDateReference(dueDate.replace("@", ""));
            return;
        }
        try {
            Period period = TimerUtils.getParsePeriod(dueDate);
            this.setDueDatePeriod(period);
        }
        catch (Exception e) {
            Date instant = TimerUtils.parseDateMultipleFormats(dueDate);
            if (Objects.isNull(this.getDueDateTimer()) && Objects.isNull(instant)) {
                throw new MacroException("Invalid Period " + dueDate + ". It must follow ISO8601 Duration Format");
            }
            this.setDueDateInstant(instant);
        }
    }

    public String getDueDate() {
        Timer dueDateTimer = this.getDueDateTimer();
        if (Objects.isNull(dueDateTimer)) {
            return null;
        }
        String period = dueDateTimer.getInstant() != null ? DUE_DATE_FORMATTER.print(dueDateTimer.getInstant().getTime()) : (dueDateTimer.getPeriod() == null ? "@" + dueDateTimer.getPeriodReference() + "@" : TimerUtils.periodToString(dueDateTimer.getPeriod()));
        return period;
    }

    private void setDueDateInstant(Date instant) {
        Timer timer = this.getDueDateTimer();
        if (Objects.isNull(timer)) {
            timer = new Timer(Timer.DUE_DATE_TIMERNAME, instant);
            this.timers.add(timer);
        } else {
            timer.setInstant(instant);
        }
        timer.setImplicit(true);
    }

    private void setDueDatePeriod(Period period) {
        Timer timer = this.getDueDateTimer();
        if (Objects.isNull(timer)) {
            timer = new Timer(Timer.DUE_DATE_TIMERNAME, period);
            this.timers.add(timer);
        } else {
            timer.setPeriod(period);
        }
        timer.setImplicit(true);
    }

    private void setDueDateReference(String reference) {
        Timer timer = this.getDueDateTimer();
        if (Objects.isNull(timer)) {
            timer = new Timer(Timer.DUE_DATE_TIMERNAME, reference);
            this.timers.add(timer);
        } else {
            timer.setImplicit(true);
            timer.setPeriod(null);
            timer.setPeriodReference(reference);
        }
    }

    public void setNoDueDate() {
        Timer dueDateTimer = this.getDueDateTimer();
        if (Objects.nonNull(dueDateTimer)) {
            this.timers.remove(dueDateTimer);
        }
    }

    public Timer getDueDateTimer() {
        for (Timer timer : this.timers) {
            if (!timer.getName().equals(Timer.DUE_DATE_TIMERNAME)) continue;
            return timer;
        }
        return null;
    }

    public List<Timer> getTimers() {
        return this.timers;
    }
}

