/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.activity;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.readack.activity.ReadAckActivityManager;
import com.comalatech.confluence.readack.activity.ReadAckActivityModel;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReadAckActivityManager
implements ReadAckActivityManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultReadAckActivityManager.class);
    public static final String READ_ACK_ACTIVITIES_KEY = "com.comalatech.readack.activities";
    public static final String READ_ACK_ACTIVITY_TIMESTAMP = "timestamp";
    public static final String READ_ACK_ACTIVITY_STATUS = "status";
    public static final String READ_ACK_ACTIVITY_VERSION = "version";
    private final ComalaPropertiesSetManager contentPropertyManager;

    public DefaultReadAckActivityManager(ComalaPropertiesSetManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    @Override
    public List<ReadAckActivityModel> getReadAckActivities(AbstractPage page) {
        ArrayList<ReadAckActivityModel> list = new ArrayList<ReadAckActivityModel>();
        try {
            String value = this.contentPropertyManager.getStringProperty((ContentEntityObject)page, READ_ACK_ACTIVITIES_KEY);
            if (TextUtils.stringSet((String)value)) {
                JsonArray json = new JsonParser().parse(value).getAsJsonArray();
                for (JsonElement obj : json) {
                    JsonObject o = obj.getAsJsonObject();
                    list.add(new ReadAckActivityModel(o.get(READ_ACK_ACTIVITY_TIMESTAMP).getAsLong(), ReadAckStatusType.PageStatusType.fromString(o.get(READ_ACK_ACTIVITY_STATUS).getAsString()), o.get(READ_ACK_ACTIVITY_VERSION) != null ? Integer.valueOf(o.get(READ_ACK_ACTIVITY_VERSION).getAsInt()) : null));
                }
            }
        }
        catch (Exception e) {
            log.debug("Error getting the list of read ack completed activities", (Throwable)e);
        }
        return list;
    }

    @Override
    public void addReadAckActivity(AbstractPage page, ReadAckActivityModel readAckActivity) {
        List<ReadAckActivityModel> list = this.getReadAckActivities(page);
        list.add(readAckActivity);
        JsonArray arr = new JsonArray();
        for (ReadAckActivityModel act : list) {
            JsonObject el = new JsonObject();
            el.addProperty(READ_ACK_ACTIVITY_TIMESTAMP, (Number)act.timestamp);
            el.addProperty(READ_ACK_ACTIVITY_STATUS, act.status.toString());
            el.addProperty(READ_ACK_ACTIVITY_VERSION, (Number)act.version);
            arr.add((JsonElement)el);
        }
        this.contentPropertyManager.setStringProperty((ContentEntityObject)page, READ_ACK_ACTIVITIES_KEY, arr.toString());
    }

    @Override
    public void removeReadAckActivities(AbstractPage page) {
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, READ_ACK_ACTIVITIES_KEY);
    }
}

