/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.event.BlogPostTaskUpdatedEvent;
import com.comalatech.confluence.states.event.PageTaskUpdatedEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.WorkflowUserException;

public class TaskUpdateMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public TaskUpdateMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageTaskUpdatedEvent) {
            PageTaskUpdatedEvent pageTaskUpdatedEvent = (PageTaskUpdatedEvent)event;
            return this.buildActivity((AbstractPage)pageTaskUpdatedEvent.getPage(), (PageState)pageTaskUpdatedEvent.getState(), (PageTask)pageTaskUpdatedEvent.getTask(), pageTaskUpdatedEvent.getPerformer());
        }
        if (event instanceof BlogPostTaskUpdatedEvent) {
            BlogPostTaskUpdatedEvent blogPostTaskUpdatedEvent = (BlogPostTaskUpdatedEvent)event;
            return this.buildActivity((AbstractPage)blogPostTaskUpdatedEvent.getBlogPost(), (PageState)blogPostTaskUpdatedEvent.getState(), (PageTask)blogPostTaskUpdatedEvent.getTask(), blogPostTaskUpdatedEvent.getPerformer());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask newTask, String performer) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(performer);
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetail.Type.TASK_NAME, newTask.getName());
        if (newTask.getComment() != null && newTask.getComment().length() > 0) {
            details.addDetail(ActionDetail.Type.TASK_DESCRIPTION, newTask.getComment());
        }
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(new ActionType(ActionType.Type.TASK, ActionType.Subtype.TASK_UPDATE), actor, details);
        return new Activity(TaskUpdateMapper.buildTarget((ContentEntityObject)abstractPage), newTask.getDate().getTime(), action);
    }
}

