/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.domain.entities.Target;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;

public class TransitionsMapper {
    private final PageManager pageManager;
    private ActorUtils actorUtils;

    public TransitionsMapper(PageManager pageManager, ActorUtils actorUtils) {
        this.pageManager = pageManager;
        this.actorUtils = actorUtils;
    }

    public Activity buildTransitionActivity(PageState pageState) {
        long moment = pageState.getDate().getTime();
        Target target = this.mapContent(pageState);
        Actor actor = this.mapPerformer(pageState);
        ActionType actionType = this.mapAction();
        Action action = this.mapTransition(actionType, actor, pageState);
        return new Activity(target, moment, action);
    }

    private Actor mapPerformer(PageState pageState) {
        String userName = pageState.getPerformer();
        return this.actorUtils.buildActor(userName, true);
    }

    private Target mapContent(PageState pageState) {
        Target target = new Target();
        AbstractPage page = pageState.getPage();
        ContentEntityObject content = this.pageManager.getOtherVersion((ContentEntityObject)page, pageState.getVersion());
        if (content != null) {
            target.setTargetId(content.getId());
        }
        target.setTargetVersion(pageState.getVersion());
        target.setSpaceKey(page.getSpaceKey());
        return target;
    }

    private ActionType mapAction() {
        ActionType actionType = new ActionType();
        actionType.setType(ActionType.Type.STATE);
        actionType.setSubtype(ActionType.Subtype.STATE_TRANSITION);
        return actionType;
    }

    private Action mapTransition(ActionType actionType, Actor actor, PageState pageState) {
        Action action = new Action();
        action.setActionType(actionType);
        action.setActor(actor);
        action.setActionDetails(this.mapActionDetails(pageState));
        return action;
    }

    private ActionDetails mapActionDetails(PageState pageState) {
        ActionDetails details = new ActionDetails();
        if (pageState.isPublished()) {
            details.addDetail(ActionDetail.Type.IS_PUBLISHED, "true");
        }
        if (pageState.getComment() != null) {
            details.addDetail(ActionDetail.Type.STATE_COMMENT, pageState.getComment());
        }
        if (pageState.getColour() != null) {
            details.addDetail(ActionDetail.Type.STATE_COLOUR, pageState.getColour());
        }
        details.addDetail(ActionDetail.Type.STATE_NAME, pageState.getName());
        return details;
    }
}

