/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.StateExpiredEventEmail;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.event.StateExpireEvent;
import com.comalatech.workflow.model.State;
import java.util.Set;

public class StateNotificationListener
extends WorkflowsListener {
    protected final WorkflowNotificationConfigManager workflowNotificationConfigManager;
    protected final AdhocNotificationService adhocNotificationService;
    protected final UserAccessor userAccessor;
    protected final WorkflowAccessor workflowAccessor;
    protected final WorkflowConfigurationManager workflowConfigurationManager;

    public StateNotificationListener(EventPublisher eventPublisher, WorkflowNotificationConfigManager workflowNotificationConfigManager, AdhocNotificationService adhocNotificationService, UserAccessor userAccessor, WorkflowAccessor workflowAccessor, WorkflowConfigurationManager workflowConfigurationManager) {
        super(eventPublisher);
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
        this.adhocNotificationService = adhocNotificationService;
        this.userAccessor = userAccessor;
        this.workflowAccessor = workflowAccessor;
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    @EventListener
    public void stateExpiredEvent(StateExpireEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.STATE_EXPIRED, page.getSpaceKey())) {
            State state = event.getState();
            Permission requiredPermission = this.getConfluencePermissionRequired(page, state);
            StateExpiredEventEmail email = new StateExpiredEventEmail();
            email.setEntityId(((ContentEntityObject)event.getContent()).getId());
            email.addContextProperty("stateName", state.getName());
            email.addContextProperty("pageTitle", page.getTitle());
            Set<ConfluenceUser> watchers = this.adhocNotificationService.getContentWatchers(page, null, true, null, null);
            this.adhocNotificationService.sendEmail(email, watchers, requiredPermission, null);
        }
    }

    protected Permission getConfluencePermissionRequired(AbstractPage page, State state) {
        WorkflowVisibilityInternal visibility;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows != null && pageWorkflows.isRequiresFinalApproval() && !state.isPublished() && WorkflowVisibilityInternal.CONTRIBUTORS == (visibility = this.workflowConfigurationManager.getHistoryVisibility(page.getSpaceKey()))) {
            return Permission.EDIT;
        }
        return Permission.VIEW;
    }
}

