/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.facade;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.randombits.facade.ArrayTypeParameter;
import org.randombits.facade.Cachable;
import org.randombits.facade.CustomObjectInputStream;
import org.randombits.facade.Facadable;
import org.randombits.facade.FacadeCache;
import org.randombits.facade.FacadeException;
import org.randombits.facade.FacadeInvocationHandler;
import org.randombits.facade.MethodSignature;
import org.randombits.facade.WeakHashMapCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacadeAssistant {
    private static final Logger LOG = Logger.getLogger(FacadeAssistant.class);
    private static final FacadeAssistant INSTANCE = new FacadeAssistant();
    private FacadeCache cache;
    private Map<Class<?>, Boolean> facadableClasses = new HashMap();
    private Map<Class<?>, Map<MethodSignature, FacadeInfo>> facadableMethods = new HashMap();

    FacadeAssistant() {
        this.cache = new WeakHashMapCache();
    }

    public static FacadeAssistant getInstance() {
        return INSTANCE;
    }

    public void setFacadeCache(FacadeCache cache) {
        if (this.cache != cache) {
            if (this.cache != null) {
                this.cache.clear();
            }
            this.cache = cache;
        }
    }

    public Object prepareObject(Object sourceObject, ClassLoader targetClassLoader) {
        return this.prepareObject(sourceObject, targetClassLoader, false);
    }

    public Object prepareObject(Object sourceObject, ClassLoader targetClassLoader, boolean facadeShared) {
        return this.prepareObject(sourceObject, Object.class, targetClassLoader, facadeShared);
    }

    public <T> T prepareObject(Object sourceObject, Class<T> targetType) {
        return this.prepareObject(sourceObject, targetType, targetType.getClassLoader(), false);
    }

    public <T> T prepareObject(Object sourceObject, Class<T> targetType, ClassLoader targetClassLoader) {
        return this.prepareObject(sourceObject, targetType, targetClassLoader, false);
    }

    public <T> T prepareObject(Object sourceObject, Class<T> targetType, ClassLoader targetClassLoader, boolean facadeShared) {
        return this.prepareObject(sourceObject, targetType, targetClassLoader, facadeShared, null);
    }

    public <T> T prepareObject(Object sourceObject, Class<T> targetType, ClassLoader targetClassLoader, boolean facadeShared, Class<?> componentType) {
        if (sourceObject == null) {
            return null;
        }
        Class<?> sourceType = sourceObject.getClass();
        ClassLoader sourceClassLoader = sourceType.getClassLoader();
        if (sourceClassLoader == targetClassLoader) {
            return (T)sourceObject;
        }
        boolean isShared = this.isShared(sourceObject, targetClassLoader);
        if (!facadeShared && isShared) {
            return (T)sourceObject;
        }
        if (Class.class.equals(sourceType)) {
            return (T)this.findClass(sourceType, targetClassLoader);
        }
        if (sourceType.isArray() && targetType.isArray()) {
            if (componentType == null) {
                componentType = targetType.getComponentType();
            }
            return (T)this.toArray(sourceObject, componentType, targetClassLoader, facadeShared);
        }
        if (sourceType.isEnum() && targetType.isEnum()) {
            return this.toEnum(sourceObject, targetType);
        }
        Object wrapped = this.getWrapped(sourceObject);
        if (wrapped != null) {
            if (targetType.isInstance(wrapped)) {
                return (T)wrapped;
            }
            sourceObject = wrapped;
        }
        Object targetObject = null;
        if ((Object.class.equals(targetType) || targetType.isInterface()) && (isShared || this.isFacadable(sourceObject, targetType))) {
            boolean cachable = this.isCachable(sourceObject);
            if (cachable) {
                targetObject = this.getCachedFacade(sourceObject, targetType);
            }
            if (targetObject == null && (targetObject = this.toFacade(sourceObject, targetType, targetClassLoader)) != null && cachable) {
                this.setCachedFacade(targetObject, sourceObject, targetType);
            }
        }
        if (targetObject == null && sourceObject instanceof Serializable && this.findClass(sourceObject.getClass(), targetClassLoader) != null) {
            targetObject = this.toSerialized(sourceObject, targetType, targetClassLoader);
        }
        if (targetObject == null) {
            targetObject = sourceObject;
        }
        return (T)targetObject;
    }

    private boolean isCachable(Object value) {
        if (value == null) {
            return false;
        }
        Class<? extends Annotation> cachable = this.findAnnotationClass(Cachable.class, value);
        if (cachable != null) {
            Annotation annotation = value.getClass().getAnnotation(cachable);
            return annotation != null;
        }
        return false;
    }

    private <T> T toSerialized(Object sourceObject, Class<T> targetType, ClassLoader targetClassLoader) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(sourceObject);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            CustomObjectInputStream in = new CustomObjectInputStream(bais, targetClassLoader);
            Object targetObject = in.readObject();
            in.close();
            if (targetType.isInstance(targetObject)) {
                return (T)targetObject;
            }
        }
        catch (IOException e) {
            throw new FacadeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new FacadeException(e);
        }
        return null;
    }

    private Object toArray(Object sourceObject, Class<?> componentType, ClassLoader targetClassLoader, boolean requireFacade) {
        componentType = this.findClass(componentType, targetClassLoader);
        int length = Array.getLength(sourceObject);
        Object targetArray = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Object sourceItem = Array.get(sourceObject, i);
            Object targetItem = this.prepareObject(sourceItem, componentType, targetClassLoader, requireFacade);
            Array.set(targetArray, i, targetItem);
        }
        return targetArray;
    }

    private <T> T toEnum(Object sourceObject, Class<T> enumType) {
        try {
            return (T)enumType.getMethod("valueOf", String.class).invoke(null, ((Enum)sourceObject).name());
        }
        catch (IllegalArgumentException e) {
            throw new FacadeException("Unexpected exception: " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new FacadeException("Unexpected exception: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new FacadeException("Unexpected exception: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new FacadeException("Unexpected exception: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new FacadeException("Unexpected exception: " + e.getMessage(), e);
        }
    }

    public boolean isLocal(Object object) {
        return object != null && this.getClass().getClassLoader().equals(object.getClass().getClassLoader());
    }

    private boolean isFacadable(Object sourceObject, Class<?> targetType) {
        Class<?> sourceType;
        if (sourceObject == null) {
            return false;
        }
        Class<? extends Annotation> facadable = this.findAnnotationClass(Facadable.class, sourceObject);
        if (facadable == null) {
            return false;
        }
        if ((Object.class.equals(targetType) || targetType != null && targetType.isInterface()) && ((sourceType = this.findClass(targetType, sourceObject)) == null || !sourceType.isInstance(sourceObject))) {
            return false;
        }
        return this.isFacadable(sourceObject.getClass(), facadable);
    }

    private boolean isFacadable(Class<?> type, Class<? extends Annotation> facadable) {
        Boolean isFacadable = this.facadableClasses.get(type);
        if (isFacadable == null) {
            isFacadable = type.isAnnotationPresent(facadable);
            if (!isFacadable.booleanValue()) {
                Class<?>[] interfaces = type.getInterfaces();
                for (int i = 0; !isFacadable.booleanValue() && i < interfaces.length; ++i) {
                    isFacadable = this.isFacadable(interfaces[i], facadable);
                }
                if (!isFacadable.booleanValue() && type.getSuperclass() != null) {
                    isFacadable = this.isFacadable(type.getSuperclass(), facadable);
                }
            }
            this.facadableClasses.put(type, isFacadable);
        }
        return isFacadable;
    }

    private Class<? extends Annotation> findAnnotationClass(Class<? extends Annotation> type, Object object) {
        return this.findAnnotationClass(type, object.getClass());
    }

    private Class<? extends Annotation> findAnnotationClass(Class<? extends Annotation> type, Class<?> sourceType) {
        return this.findAnnotationClass(type, sourceType.getClassLoader());
    }

    private Class<? extends Annotation> findAnnotationClass(Class<? extends Annotation> type, ClassLoader classLoader) {
        return this.findClass(type, classLoader);
    }

    public Class<?> findClass(Class<?> sourceType, Object target) {
        return this.findClass(sourceType, target != null ? target.getClass().getClassLoader() : null);
    }

    public Class<?> findClass(Class<?> sourceType, ClassLoader targetClassLoader) {
        if (sourceType.getClassLoader() == targetClassLoader) {
            return sourceType;
        }
        if (sourceType.isPrimitive()) {
            return sourceType;
        }
        return this.findClass(sourceType.getName(), targetClassLoader);
    }

    public Class<?> findClass(String classname, Object targetObject) {
        return this.findClass(classname, targetObject != null ? targetObject.getClass().getClassLoader() : null);
    }

    public Class<?> findClass(String classname, ClassLoader targetClassLoader) {
        try {
            return Class.forName(classname, true, targetClassLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public boolean isShared(Object object, ClassLoader targetClassLoader) {
        if (object == null) {
            return true;
        }
        Class<?> sourceClass = object.getClass();
        Class<?> targetClass = this.findClass(object.getClass(), targetClassLoader);
        return sourceClass != null && sourceClass == targetClass && sourceClass.getClassLoader() != targetClassLoader;
    }

    private <T> T toFacade(Object facadable, Class<T> targetType, ClassLoader targetClassLoader) {
        InvocationHandler invocationHandler;
        if (!this.isFacadable(facadable, targetType)) {
            return null;
        }
        Class<?>[] interfaces = this.getAllInterfaces(facadable);
        try {
            interfaces = this.toFacadeClasses(interfaces, targetClassLoader, false);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e);
        }
        if (interfaces != null && interfaces.length > 0 && (invocationHandler = this.createInvocationHandler(targetClassLoader, facadable)) != null) {
            return (T)Proxy.newProxyInstance(targetClassLoader, interfaces, invocationHandler);
        }
        return null;
    }

    private InvocationHandler createInvocationHandler(ClassLoader targetClassLoader, Object facadable) {
        try {
            Class<?> handlerClass = Class.forName(FacadeInvocationHandler.class.getName(), true, targetClassLoader);
            Constructor<?> cnst = handlerClass.getConstructor(Object.class);
            return (InvocationHandler)cnst.newInstance(facadable);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (SecurityException e) {
            LOG.warn((Object)("Incompatible version of Facade: " + e.getMessage()), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.warn((Object)("Incompatible version of Facade: " + e.getMessage()), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)("Incompatible version of Facade: " + e.getMessage()), (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.warn((Object)("Error while creating Facade: " + e.getMessage()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)("Incompatible version of Facade: " + e.getMessage()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.warn((Object)("Incompatible version of Facade: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private Class<?>[] getAllInterfaces(Object object) {
        HashSet interfaces = new HashSet();
        this.addAllInterfaces(interfaces, object.getClass());
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private void addAllInterfaces(Set<Class<?>> interfaces, Class<?> clazz) {
        Class<?>[] classInterfaces;
        for (Class<?> classInterface : classInterfaces = clazz.getInterfaces()) {
            if (interfaces.contains(classInterface)) continue;
            interfaces.add(classInterface);
            this.addAllInterfaces(interfaces, classInterface);
        }
        if (clazz.getSuperclass() != null) {
            this.addAllInterfaces(interfaces, clazz.getSuperclass());
        }
    }

    Class<?>[] toFacadeClasses(Class<?>[] sourceClasses, ClassLoader targetClassLoader, boolean requireClass) throws ClassNotFoundException {
        Class[] targetInterfaces = new Class[sourceClasses.length];
        int targetIndex = 0;
        for (Class<?> sourceClass : sourceClasses) {
            try {
                targetInterfaces[targetIndex] = Class.forName(sourceClass.getName(), false, targetClassLoader);
                ++targetIndex;
            }
            catch (ClassNotFoundException e) {
                if (!requireClass) continue;
                throw e;
            }
        }
        sourceClasses = new Class[targetIndex];
        System.arraycopy(targetInterfaces, 0, sourceClasses, 0, targetIndex);
        return sourceClasses;
    }

    private <T> T getCachedFacade(Object object, Class<T> type) {
        if (this.cache != null) {
            return this.cache.get(object, type);
        }
        return null;
    }

    private <T> void setCachedFacade(T facade, Object sourceObject, Class<T> targetType) {
        if (this.cache != null) {
            this.cache.set(sourceObject, facade, targetType);
        }
    }

    public boolean isLocalFacade(Object object) {
        return this.getInvocationHandler(object, FacadeInvocationHandler.class) != null;
    }

    public boolean isFacade(Object object) {
        InvocationHandler handler = this.getInvocationHandler(object);
        Class<?> facadeHandler = this.findClass(FacadeInvocationHandler.class, object);
        return facadeHandler != null && facadeHandler.isInstance(handler);
    }

    private InvocationHandler getInvocationHandler(Object object) {
        return this.getInvocationHandler(object, InvocationHandler.class);
    }

    private <T extends InvocationHandler> T getInvocationHandler(Object object, Class<T> type) {
        InvocationHandler handler;
        if (object != null && Proxy.isProxyClass(object.getClass()) && type.isInstance(handler = Proxy.getInvocationHandler(object))) {
            return (T)((InvocationHandler)type.cast(handler));
        }
        return null;
    }

    public Object getWrapped(Object facade) {
        return this.getWrapped(facade, Object.class);
    }

    public <W> W getWrapped(Object facade, Class<W> wrappedClass) {
        Class<?> facadeClass;
        Object wrapped = null;
        InvocationHandler handler = this.getInvocationHandler(facade, InvocationHandler.class);
        if (handler instanceof FacadeInvocationHandler) {
            wrapped = ((FacadeInvocationHandler)handler).wrapped;
        } else if (handler != null && (facadeClass = this.findClass(FacadeInvocationHandler.class, (Object)handler)) != null && facadeClass.isInstance(handler)) {
            try {
                wrapped = facadeClass.getDeclaredMethod("getWrapped", new Class[0]).invoke((Object)handler, new Object[0]);
            }
            catch (SecurityException e) {
                throw new FacadeException("Unexpected security exception: " + e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new FacadeException("Unexpected illegal access exception: " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new FacadeException("Unexpected illegal access exception: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                throw new FacadeException("Unexpected no such method exception: " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new FacadeException("Unexpected invocation target exception: " + e.getMessage(), e);
            }
        }
        if (wrappedClass.isInstance(wrapped)) {
            return (W)wrapped;
        }
        return null;
    }

    FacadeInfo findFacadeInfo(Class<?> type, MethodSignature signature) {
        FacadeInfo info;
        if (type == null || signature.findMethod(type) == null) {
            return null;
        }
        Map<MethodSignature, FacadeInfo> signatureMap = this.facadableMethods.get(type);
        if (signatureMap == null) {
            signatureMap = new HashMap<MethodSignature, FacadeInfo>();
            this.facadableMethods.put(type, signatureMap);
        } else {
            info = signatureMap.get(signature);
            if (info != null || signatureMap.containsKey(signature)) {
                return info;
            }
        }
        info = new FacadeInfo(type, signature);
        signatureMap.put(signature, info);
        return info;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FacadeInfo {
        private boolean returnFacadable;
        private int arrayTypeParameter = -1;
        private boolean[] parameterFacadable;

        public FacadeInfo(Class<?> type, MethodSignature signature) {
            this.parameterFacadable = new boolean[signature.getParameterCount()];
            Class facadable = FacadeAssistant.this.findAnnotationClass((Class<? extends Annotation>)Facadable.class, type);
            Class arrayTypeParam = FacadeAssistant.this.findAnnotationClass((Class<? extends Annotation>)ArrayTypeParameter.class, type);
            if (facadable != null) {
                this.checkMethod(type, signature, facadable, arrayTypeParam);
            }
        }

        public boolean isReturnFacadable() {
            return this.returnFacadable;
        }

        public int getArrayTypeParameter() {
            return this.arrayTypeParameter;
        }

        public boolean isParameterFacadable(int i) {
            return this.parameterFacadable[i];
        }

        public int getParameterCount() {
            return this.parameterFacadable.length;
        }

        private boolean checkMethod(Class<?> type, MethodSignature signature, Class<? extends Annotation> facadable, Class<? extends Annotation> arrayTypeParam) {
            int i;
            boolean allFacadable = false;
            Method method = signature.findDeclaredMethod(type);
            if (method != null) {
                allFacadable = true;
                if (this.arrayTypeParameter == -1) {
                    this.arrayTypeParameter = this.findArrayTypeParameter(method, arrayTypeParam);
                    boolean bl = allFacadable = this.arrayTypeParameter != -1;
                }
                if (!this.returnFacadable) {
                    this.returnFacadable = method.isAnnotationPresent(facadable);
                    allFacadable = allFacadable && this.returnFacadable;
                }
                Annotation[][] pa = method.getParameterAnnotations();
                for (i = 0; i < pa.length; ++i) {
                    int j;
                    if (this.parameterFacadable[i]) continue;
                    Annotation[] a = pa[i];
                    for (j = 0; j < a.length; ++j) {
                        if (!facadable.equals(a[i])) continue;
                        this.parameterFacadable[i] = true;
                        break;
                    }
                    allFacadable = allFacadable && j < a.length;
                }
            }
            if (!allFacadable) {
                Class<?>[] interfaces = type.getInterfaces();
                if (interfaces != null) {
                    for (i = 0; !allFacadable && i < interfaces.length; ++i) {
                        allFacadable = this.mergeInfo(FacadeAssistant.this.findFacadeInfo(interfaces[i], signature));
                    }
                }
                if (!allFacadable) {
                    allFacadable = this.mergeInfo(FacadeAssistant.this.findFacadeInfo(type.getSuperclass(), signature));
                }
            }
            return allFacadable;
        }

        private int findArrayTypeParameter(Method method, Class<? extends Annotation> arrayTypeParam) {
            Annotation a = method.getAnnotation(arrayTypeParam);
            if (a != null) {
                try {
                    return (Integer)a.getClass().getMethod("value", new Class[0]).invoke((Object)a, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    LOG.error((Object)e);
                }
                catch (SecurityException e) {
                    LOG.error((Object)e);
                }
                catch (IllegalAccessException e) {
                    LOG.error((Object)e);
                }
                catch (InvocationTargetException e) {
                    LOG.error((Object)e);
                }
                catch (NoSuchMethodException e) {
                    LOG.error((Object)e);
                }
            }
            return -1;
        }

        private boolean mergeInfo(FacadeInfo info) {
            if (info != null) {
                boolean allFacadable = true;
                if (this.parameterFacadable != null) {
                    if (info.parameterFacadable == null || this.parameterFacadable.length != info.parameterFacadable.length) {
                        return false;
                    }
                    for (int i = 0; i < this.parameterFacadable.length; ++i) {
                        this.parameterFacadable[i] = this.parameterFacadable[i] || info.parameterFacadable[i];
                        allFacadable = allFacadable && this.parameterFacadable[i];
                    }
                } else if (info.parameterFacadable != null) {
                    return false;
                }
                this.returnFacadable = this.returnFacadable || info.returnFacadable;
                boolean bl = allFacadable = allFacadable && this.returnFacadable;
                if (this.arrayTypeParameter == -1) {
                    this.arrayTypeParameter = info.arrayTypeParameter;
                }
                boolean bl2 = allFacadable && this.arrayTypeParameter != -1;
            }
            return false;
        }
    }
}

