/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rules.permission;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.rules.permission.PermissionRule;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasPageWorkflow
implements PermissionRule<AbstractPage> {
    private static final Logger log = LoggerFactory.getLogger(HasPageWorkflow.class);
    private AdhocWorkflowManager adhocWorkflowManager;

    public HasPageWorkflow(AdhocWorkflowManager adhocWorkflowManager) {
        this.adhocWorkflowManager = adhocWorkflowManager;
    }

    @Override
    public boolean validate(AbstractPage page, boolean hiddenStates) {
        try {
            if (this.adhocWorkflowManager.hasWorkflow(page)) {
                if (hiddenStates) {
                    Workflow workflow = this.adhocWorkflowManager.getPageWorkflow(page);
                    if (workflow != null && !workflow.isHideStates()) {
                        return true;
                    }
                    throw new IllegalArgumentException(MessageFormat.format("Page workflow value is {1}", workflow));
                }
                return true;
            }
            throw new IllegalArgumentException("Page does not have workflow!");
        }
        catch (WorkflowException | IllegalArgumentException ex) {
            log.debug("Page {} does not have Worflows, reason {} ", (Object)page, (Object)ex);
            return false;
        }
    }
}

