/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rpc;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteApprovalCheck {
    private String name;
    private String comment;
    private boolean approved;
    private String userName;
    private Date date;
    private int version;
    private String pageName;
    private Vector nextApprovalUsers;
    private Vector checkedAttachments;
    private Date postDate;
    private String errorStatusMessage;

    public RemoteApprovalCheck(String errorMessage) {
        this.errorStatusMessage = errorMessage;
    }

    public RemoteApprovalCheck(AbstractPage page, ApprovalCheck approvalCheck, Vector checkedAttachments) {
        this.name = approvalCheck.getName();
        Approver approver = approvalCheck.getLastApprover();
        this.comment = approver.getComment();
        this.approved = approver.isApproved();
        this.userName = approver.getUser();
        this.date = approver.getDate();
        this.pageName = page.getTitle();
        if (page instanceof BlogPost) {
            this.postDate = page.getCreationDate();
        }
        this.version = approvalCheck.getVersion();
        this.nextApprovalUsers = new Vector();
        this.checkedAttachments = checkedAttachments;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public String getUserName() {
        return this.userName;
    }

    public Date getDate() {
        return this.date;
    }

    public int getVersion() {
        return this.version;
    }

    public String getPageName() {
        return this.pageName;
    }

    public Vector getNextApprovalUsers() {
        return this.nextApprovalUsers;
    }

    public Vector getCheckedAttachments() {
        return this.checkedAttachments;
    }

    public Date getPostDate() {
        return this.postDate;
    }

    public String getErrorStatusMessage() {
        return this.errorStatusMessage;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

