/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork;

import com.comalatech.confluence.workflow.mywork.LocalTaskServiceAccessor;
import com.comalatech.confluence.workflow.mywork.LocalTaskServiceFactory;
import com.comalatech.confluence.workflow.mywork.LocalTaskServiceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class LocalTaskServiceAccessorImpl
implements LocalTaskServiceAccessor {
    private static final Logger log = LoggerFactory.getLogger(LocalTaskServiceAccessorImpl.class);
    private final ApplicationContext applicationContext;
    private LocalTaskServiceHolder localtaskServiceHolder;

    public LocalTaskServiceAccessorImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public synchronized LocalTaskServiceHolder getLocalTaskService() {
        if (this.localtaskServiceHolder == null) {
            this.initNotificationService();
        }
        return this.localtaskServiceHolder;
    }

    private void initNotificationService() {
        try {
            Class<?> taskServiceFactoryClass = this.getTaskServiceFactoryClass();
            if (taskServiceFactoryClass != null) {
                this.localtaskServiceHolder = ((LocalTaskServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(taskServiceFactoryClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.debug("Could not create LocalTaskServiceHolder", (Throwable)e);
        }
    }

    private Class<?> getTaskServiceFactoryClass() {
        try {
            this.getClass().getClassLoader().loadClass("com.atlassian.mywork.service.LocalTaskService");
            return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.workflow.mywork.LocalTaskServiceFactory");
        }
        catch (Exception e) {
            log.info("The necessary mywork class is unavailable.");
            return null;
        }
    }
}

