/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.comalatech.confluence.states.event.AllTasksCompleteEvent;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.event.StateSelectEvent;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.Timer;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.StateCondition;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.List;
import org.joda.time.DateTime;

public class Transition
extends Trigger {
    private State nextState;
    private State sourceState;
    private boolean forward;

    public Transition(ConfluenceEvent event, List<Condition> conditions, State sourceState, State nextState, boolean forward) {
        super(event, false, null, conditions, null, false, null, null);
        if (sourceState != null) {
            this.prependCondition(new StateCondition(false, sourceState.getName()));
        }
        this.sourceState = sourceState;
        this.nextState = nextState;
        this.forward = forward;
    }

    public boolean isForward() {
        return this.forward;
    }

    public State getSourceState() {
        return this.sourceState;
    }

    public State getNextState() {
        return this.nextState;
    }

    @Override
    public SerializableMacro toMacro() {
        return null;
    }

    @Override
    public boolean evaluate(ValueStore valueStore) throws WorkflowException {
        return super.evaluate(valueStore);
    }

    @Override
    public String getAction(ConfluenceEvent event) {
        if (event instanceof StateSelectEvent) {
            StateSelectEvent stateSelectEvent = (StateSelectEvent)event;
            return this.makeStateSelectionMacro(stateSelectEvent);
        }
        if (event instanceof StateExpireEvent) {
            return this.makeStateExpirationMacro(this.nextState);
        }
        if (event instanceof AllTasksCompleteEvent) {
            return this.makeAllTasksCompletedMacro(this.nextState);
        }
        if (this.nextState == null) {
            return "";
        }
        return "{set-state:" + this.nextState.getName() + "}";
    }

    private String makeAllTasksCompletedMacro(State nextState) {
        if (nextState == null) {
            return "";
        }
        SerializableMacro macro = new SerializableMacro("set-state");
        macro.addParameter(nextState.getName());
        return macro.toString();
    }

    private String makeStateExpirationMacro(State nextState) {
        if (nextState == null) {
            return "";
        }
        SerializableMacro macro = new SerializableMacro("set-state");
        macro.addParameter(nextState.getName()).addParameter("comment", (Object)ConfluenceActionSupport.getTextStatic((String)"com.awp.stateexpired.comment"));
        return macro.toString();
    }

    private String makeStateSelectionMacro(StateSelectEvent stateSelectEvent) {
        if (stateSelectEvent.getSelectedState() == null) {
            return "";
        }
        Assignment assignment = stateSelectEvent.getAssignment();
        SerializableMacro macro = new SerializableMacro("set-state");
        macro.addParameter(stateSelectEvent.getSelectedState().getName()).addParameter("comment", (Object)stateSelectEvent.getComment()).addParameter("duedate", (Object)this.formatDueDate(stateSelectEvent.getAssignment()));
        if (assignment != null) {
            macro.addParameter("users", (Object)assignment.getAssignee()).addParameter("groups", (Object)assignment.getGroups());
        }
        return macro.toString();
    }

    private String formatDueDate(Assignment assignment) {
        if (assignment == null || assignment.getDueDate() == null) {
            return null;
        }
        return Timer.FORMATTER.print(new DateTime(assignment.getDueDate()));
    }
}

