/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function(CW, $) {
    CW.toInit(function () {
        var urlPath = '/admin/global/import';

        if(CW.getParam('spaceKey')) {
            urlPath = '/admin/space/' + CW.getParam('spaceKey') + '/import';
        }

        var WorkflowsListIframe = new CW.iframe({
            id: 'WorkflowsListIframe',
            url: urlPath,
            width: '100%',
            height: '100%'
        });
        $('#cw-importworkflows-container').html(WorkflowsListIframe.render());

       // Modal: Import Workflows
       CW.connect("importWorkflows", function (modalDataJSON) {
            var modalData = JSON.parse(modalDataJSON);

            var importWorkflowsModal = new CW.Dialog({
                id: 'cw-importWorkflows',
                width: 500,
                height: 300,
                path: '/modal/importworkflows',
                query: {
                    urlAction: modalData.url,
                    isImportedInSpace: modalData.isImportedInSpace,
                    isImportedInPage: modalData.isImportedInPage
                }
            });
            importWorkflowsModal.show();
        });
    });
});
