/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.supplier;

import java.util.Comparator;
import net.customware.confluence.reporting.supplier.SupplierValueException;
import org.apache.log4j.Logger;
import org.randombits.confluence.supplier.SupplierAssistant;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.confluence.supplier.UnsupportedContextException;

public class SupplierValueComparator<T, V>
implements Comparator<T> {
    private static final Logger LOG = Logger.getLogger(SupplierValueComparator.class);
    private String key;
    private Comparator<? super V> comparator;
    private boolean renderWiki;

    public SupplierValueComparator(String key, Comparator<? super V> comparator) {
        this(key, comparator, false);
    }

    public SupplierValueComparator(String key, Comparator<? super V> comparator, boolean renderWiki) {
        this.key = key;
        this.comparator = comparator;
        this.renderWiki = renderWiki;
    }

    @Override
    public int compare(T t1, T t2) {
        Object v2;
        Object v1;
        if (this.key != null) {
            try {
                v1 = SupplierAssistant.getInstance().findValue(t1, this.key, this.renderWiki);
            }
            catch (UnsupportedContextException e) {
                LOG.warn((Object)("Unsupported context on key: " + this.key), (Throwable)e);
                return -1;
            }
            catch (SupplierException e) {
                LOG.warn((Object)("Supplier exception on key: " + this.key), (Throwable)e);
                return -2;
            }
            try {
                v2 = SupplierAssistant.getInstance().findValue(t2, this.key, this.renderWiki);
            }
            catch (UnsupportedContextException e) {
                LOG.warn((Object)("Unsupported context on key: " + this.key), (Throwable)e);
                return 1;
            }
            catch (SupplierException e) {
                LOG.warn((Object)("Supplier exception on key: " + this.key), (Throwable)e);
                return 2;
            }
        }
        v1 = t1;
        v2 = t2;
        try {
            return this.comparator.compare(v1, v2);
        }
        catch (ClassCastException e) {
            throw new SupplierValueException(this.key, "Unsupported class type", e);
        }
        catch (RuntimeException e) {
            throw new SupplierValueException(this.key, null, e);
        }
    }

    public boolean isRenderWiki() {
        return this.renderWiki;
    }

    public void setRenderWiki(boolean renderWiki) {
        this.renderWiki = renderWiki;
    }
}

