/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.mappers;

import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.StateReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.StringListReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class StringListParameterMapper
implements ParameterMapper {
    @Override
    public ReportParameter map(ReportParameter parameter) {
        if (this.parameterCanBeMapped(parameter)) {
            StringReportParameterValue paramValue = (StringReportParameterValue)parameter.getValue();
            String fieldsValueExpression = (String)paramValue.getValue();
            String defaultFieldsValueExpression = (String)paramValue.getDefaultValue();
            List<String> fieldsValue = this.extractValuesFromExpression(fieldsValueExpression);
            List<String> defaultFieldsValue = this.extractValuesFromExpression(defaultFieldsValueExpression);
            parameter.setValue(new StringListReportParameterValue(fieldsValue, defaultFieldsValue));
        }
        return parameter;
    }

    @Override
    public boolean parameterCanBeMapped(ReportParameter parameter) {
        return parameter.getValue() instanceof StringReportParameterValue && (parameter.keyIs(StateReportParameters.SPACE.getKey()) || parameter.keyIs(StateReportParameters.LABEL.getKey()) || parameter.keyIs(StateReportParameters.STATE.getKey()) || parameter.keyIs(StateReportParameters.WORKFLOW.getKey()));
    }

    private List<String> extractValuesFromExpression(String commaSeparatedValues) {
        ArrayList<String> values = new ArrayList<String>();
        for (String value : MiscUtils.splitAndTrim(commaSeparatedValues)) {
            if (!TextUtils.stringSet((String)value.trim())) continue;
            values.add(value.trim());
        }
        return values;
    }
}

