/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.parser;

import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.macros.WorkflowMacro;
import com.comalatech.confluence.workflow.parser.WorkflowParser;
import com.comalatech.confluence.workflow.parser.WorkflowPreProcessor;
import com.comalatech.confluence.workflowcontainer.WorkflowContainer;
import com.opensymphony.util.TextUtils;

public class WorkflowWikiParser
implements WorkflowParser {
    protected final WikiStyleRenderer wikiStyleRenderer;
    protected final WorkflowPreProcessor workflowPreProcessor;

    public WorkflowWikiParser(WikiStyleRenderer wikiStyleRenderer, WorkflowPreProcessor workflowPreProcessor) {
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.workflowPreProcessor = workflowPreProcessor;
    }

    @Override
    public Workflow parseWorkflow(String workflowBody) throws WorkflowException {
        return this.parseWorkflow(workflowBody, (RenderContext)new Page().toPageContext());
    }

    @Override
    public Workflow parseWorkflow(String workflowBody, RenderContext context) throws WorkflowException {
        if (!TextUtils.stringSet((String)workflowBody)) {
            throw new WorkflowUserException("comalatech.awp.designer.error.markup", "no workflow found");
        }
        PageWorkflowContainer pageWorkflowContainer = new PageWorkflowContainer();
        WorkflowMacro.setWorkflowContainer(context, pageWorkflowContainer);
        String response = this.wikiStyleRenderer.convertWikiToXHtml(context, workflowBody);
        Workflow workflow = pageWorkflowContainer.getWorkflow();
        if (workflow == null) {
            throw new WorkflowUserException("comalatech.awp.designer.error.markup", response.trim());
        }
        if (response.contains("error")) {
            workflow.setErrorMessage(response);
        }
        return workflow;
    }

    public class PageWorkflowContainer
    implements WorkflowContainer {
        Workflow workflow;

        public Workflow getWorkflow(String workflowId) throws WorkflowException {
            return this.workflow;
        }

        @Override
        public void saveWorkflow(Workflow workflow) throws WorkflowException {
            this.workflow = workflow;
            WorkflowWikiParser.this.workflowPreProcessor.process(this.workflow);
        }

        public Workflow getWorkflow() {
            return this.workflow;
        }
    }
}

