/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util.db;

import com.atlassian.core.util.PairType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(SqlQueryBuilder.class);
    public static final String ORACLE_DATABASE_ENGINE = "oracle";
    public static final String MYSQL_DATABASE_ENGINE = "mysql";
    public static final String SQL_SERVER_DATABASE_ENGINE = "sqlserver";
    public static final String POSTGRES_DATABASE_ENGINE = "postgres";
    public static final String H2_DATABASE_ENGINE = "h2";
    public static final String ORDER_DESC = "DESC";
    private String databaseProduct;
    private String table;
    private PairType filter;
    private String sort;
    private String order;
    private Integer limit;
    private UnaryOperator<String> format;
    private List<String> fields;

    private SqlQueryBuilder() {
    }

    public String existTableQuery() {
        String selectQuery = this.databaseProduct.contains(ORACLE_DATABASE_ENGINE) ? "SELECT TABLE_NAME FROM ALL_TABLES where TABLE_NAME='" + this.table + "'" : "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.%s where TABLE_NAME='" + this.table + "'";
        String query = String.format(selectQuery, this.format.apply("TABLES"));
        log.info("Driver name: {}, Query{}", (Object)this.databaseProduct, (Object)query);
        return query;
    }

    public String selectQuery() {
        StringBuilder query = new StringBuilder("");
        String fieldList = "*";
        if (!this.fields.isEmpty()) {
            fieldList = this.fields.stream().collect(Collectors.joining(","));
        }
        if (this.limit != null) {
            if (this.databaseProduct.contains(SQL_SERVER_DATABASE_ENGINE)) {
                query.append("SELECT TOP " + this.limit + " " + fieldList + " FROM ");
            } else {
                query.append("SELECT " + fieldList + " FROM ");
            }
        } else {
            query.append("SELECT " + fieldList + " FROM ");
        }
        query.append((String)this.format.apply(this.table)).append(" ");
        if (this.filter != null) {
            query.append(" WHERE ").append((String)this.format.apply(this.filter.getKey().toString())).append(" = '" + this.filter.getValue().toString() + "' ");
        }
        if (this.order != null) {
            query.append("ORDER BY ").append((String)this.format.apply(this.order)).append(" ");
            if (this.sort != null) {
                query.append(this.sort).append(" ");
            }
        }
        if (this.limit != null && (this.databaseProduct.contains(MYSQL_DATABASE_ENGINE) || this.databaseProduct.contains(POSTGRES_DATABASE_ENGINE)) || this.databaseProduct.contains(H2_DATABASE_ENGINE)) {
            String limitClause = "LIMIT " + this.limit;
            query.append(limitClause).append(" ");
        }
        if (this.limit != null && this.databaseProduct.contains(ORACLE_DATABASE_ENGINE)) {
            String mainQuery = "SELECT " + fieldList + " FROM (";
            query.insert(0, mainQuery);
            query.append(") WHERE ROWNUM <= " + this.limit);
        }
        log.info("Driver name: {}, Query: {}", (Object)this.databaseProduct, (Object)query.toString());
        return query.toString();
    }

    public static class Builder {
        private String databaseProduct;
        private String table;
        private PairType filter;
        private String sort;
        private String order;
        private Integer limit;
        private UnaryOperator<String> format;
        private List<String> fields;

        public Builder(String databaseProduct, UnaryOperator<String> format) {
            this.databaseProduct = databaseProduct;
            this.format = format;
            this.fields = new ArrayList<String>();
        }

        public Builder withFilter(PairType filter) {
            this.filter = filter;
            return this;
        }

        public Builder addTable(String table) {
            this.setTable(table);
            return this;
        }

        public Builder addOrder(String order) {
            this.order = order;
            return this;
        }

        public Builder addSort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder addLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder addField(String field) {
            this.fields.add(field);
            return this;
        }

        public SqlQueryBuilder build() {
            SqlQueryBuilder sqlQueryBuilder = new SqlQueryBuilder();
            sqlQueryBuilder.databaseProduct = this.databaseProduct;
            sqlQueryBuilder.filter = this.filter;
            sqlQueryBuilder.order = this.order;
            sqlQueryBuilder.sort = this.sort;
            sqlQueryBuilder.table = this.table;
            sqlQueryBuilder.limit = this.limit;
            sqlQueryBuilder.format = this.format;
            sqlQueryBuilder.fields = this.fields;
            return sqlQueryBuilder;
        }

        private void setTable(String table) {
            if (this.databaseProduct != null) {
                this.table = this.databaseProduct.contains(SqlQueryBuilder.POSTGRES_DATABASE_ENGINE) ? table.toLowerCase() : table;
            }
        }
    }
}

