/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.comalatech.confluence.workflow.audit.AuditRecordImpl;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonSerialiserUtil<T> {
    private Gson gsonSerializer = new Gson();
    private Type type;
    private Type listType;
    TypeTokenFactory typeTokenFactory = new TypeTokenFactory();

    public JsonSerialiserUtil(Class<T> clazz) {
        this.type = this.typeTokenFactory.getType(clazz);
        this.listType = this.typeTokenFactory.getListType(clazz);
    }

    public String serialiseList(List<T> l) {
        return this.gsonSerializer.toJson(l);
    }

    public List<T> deserialiseList(String json) {
        return (List)this.gsonSerializer.fromJson(json, this.listType);
    }

    public String serialise(T o) {
        return this.gsonSerializer.toJson(o);
    }

    public T deserialise(String json) {
        return (T)this.gsonSerializer.fromJson(json, this.type);
    }

    public static boolean isJSONValid(String jsonInString) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(jsonInString);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    class TypeTokenFactory {
        TypeTokenFactory() {
        }

        Type getType(Class clazz) {
            if (clazz.getName().equals(AuditRecordImpl.class.getName())) {
                return new TypeToken<AuditRecordImpl>(){}.getType();
            }
            return null;
        }

        Type getListType(Class clazz) {
            if (clazz.getName().equals(AuditRecordImpl.class.getName())) {
                return new TypeToken<List<AuditRecordImpl>>(){}.getType();
            }
            return null;
        }
    }
}

