/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider.confluence.filter;

import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.Comment;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.CommentActivityFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.PageEditActivityFilter;
import java.util.Date;
import java.util.Optional;

public class NextActivityFilter
implements PageEditActivityFilter,
CommentActivityFilter {
    @Override
    public boolean filter(VersionHistorySummary version, DocumentActivityQuery query) {
        return this.match(version.getLastModificationDate().getTime(), query);
    }

    @Override
    public boolean filter(Comment comment, DocumentActivityQuery query) {
        return this.match(comment.getCreationDate().getTime(), query);
    }

    private boolean match(Long moment, DocumentActivityQuery query) {
        if (DocumentActivityQuery.SortingOrder.asc != query.getSorting()) {
            long fromMoment = Optional.ofNullable(query.getNextActivityTimestamp()).orElse(new Date().getTime());
            return fromMoment >= moment;
        }
        long fromMoment = Optional.ofNullable(query.getNextActivityTimestamp()).orElse(0L);
        return fromMoment <= moment;
    }
}

