/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.cloud.migration.accessor.AttachActivityAccessor;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskRecord;
import com.comalatech.confluence.cloud.migration.entity.AttachActivityTaskStatus;
import com.comalatech.confluence.cloud.migration.service.CloudMigrationContentService;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.accesor.ContentRestrictionWorkflowRecordAccessor;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.ContentActivityCSVWorkflowRecord;
import com.comalatech.confluence.workflow.accesor.entity.ContentRestrictionWorkflowRecord;
import com.comalatech.confluence.workflow.accesor.entity.PageActivityRecord;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvServiceImpl;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCloudMigrationContentService
implements CloudMigrationContentService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudMigrationContentService.class);
    private final WorkflowsActivityRecordAccessor workflowsActivityRecordAccessor;
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final AttachActivityAccessor attachCSVAccessor;
    private final ActivityManager activityManager;
    private final AttachmentManager attachmentManager;
    private final PageActivityCsvServiceImpl pageActivityCsvService;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final WorkflowContainerManager workflowContainerManager;
    private final StateService stateService;
    private final ContentRestrictionWorkflowRecordAccessor contentRestrictionWorkflowRecordAccessor;

    public DefaultCloudMigrationContentService(WorkflowsActivityRecordAccessor workflowsActivityRecordAccessor, PageManager pageManager, SpaceManager spaceManager, AttachActivityAccessor attachCSVAccessor, ActivityManager activityManager, AttachmentManager attachmentManager, PageActivityCsvServiceImpl pageActivityCsvService, ContentRestrictionWorkflowRecordAccessor contentRestrictionWorkflowRecordAccessor, ReadWriteTransactionService readWriteTransactionService, AdhocWorkflowManager adhocWorkflowManager, WorkflowContainerManager workflowContainerManager, StateService stateService) {
        this.workflowsActivityRecordAccessor = workflowsActivityRecordAccessor;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.attachCSVAccessor = attachCSVAccessor;
        this.activityManager = activityManager;
        this.attachmentManager = attachmentManager;
        this.pageActivityCsvService = pageActivityCsvService;
        this.contentRestrictionWorkflowRecordAccessor = contentRestrictionWorkflowRecordAccessor;
        this.readWriteTransactionService = readWriteTransactionService;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowContainerManager = workflowContainerManager;
        this.stateService = stateService;
    }

    @Override
    public List<Long> getPagesWithWorkflow(Long spaceId) {
        List<PageActivityRecord> records = this.workflowsActivityRecordAccessor.findAllWorkflowActivityBySpace(spaceId);
        return records.stream().map(PageActivityRecord::getPageId).filter(this::hasWorkflowActive).collect(Collectors.toList());
    }

    @Override
    public List<ContentActivityCSVWorkflowRecord> getSpacesWithNoCSVAttachments(List<String> spaceKeys) {
        return this.readWriteTransactionService.executeInReadOnlyTransaction(() -> {
            ArrayList records = new ArrayList();
            spaceKeys.forEach(spaceKey -> {
                Space space;
                AttachActivityTaskRecord activityTaskRecord = this.getStatus((String)spaceKey);
                if (!AttachActivityTaskStatus.COMPLETED.equals((Object)activityTaskRecord.getStatus()) && (space = this.spaceManager.getSpace(spaceKey)) != null) {
                    records.add(new ContentActivityCSVWorkflowRecord((String)spaceKey, space.getName(), activityTaskRecord.getStatus()));
                }
            });
            return records;
        });
    }

    @Override
    public AttachActivityTaskRecord getStatus(String spaceKey) {
        return this.attachCSVAccessor.getStatus(spaceKey);
    }

    @Override
    public void setStatus(String spaceKey, AttachActivityTaskRecord status) {
        this.attachCSVAccessor.setStatus(spaceKey, status);
    }

    @Override
    public void attachCsvToPage(long pageId) {
        try {
            AbstractPage page = this.pageManager.getAbstractPage(pageId);
            String csv = this.generateCsv(page);
            this.addCsvAsAttachmentToPage(page, csv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ContentRestrictionWorkflowRecord> getContentWithRestrictions(List<String> spaceIdList) {
        return this.readWriteTransactionService.executeInReadOnlyTransaction(() -> {
            ArrayList<ContentRestrictionWorkflowRecord> contentRestrictionWorkflowRecordList = new ArrayList<ContentRestrictionWorkflowRecord>();
            contentRestrictionWorkflowRecordList.addAll(this.contentRestrictionWorkflowRecordAccessor.findAllContentRestrictionSpaceWorkflows(spaceIdList));
            contentRestrictionWorkflowRecordList.addAll(this.contentRestrictionWorkflowRecordAccessor.findAllContentRestrictionWorkflows(spaceIdList));
            contentRestrictionWorkflowRecordList.addAll(this.contentRestrictionWorkflowRecordAccessor.findAllContentInheritedRestrictionSpaceWorkflows(spaceIdList));
            contentRestrictionWorkflowRecordList.addAll(this.contentRestrictionWorkflowRecordAccessor.findAllContentInheritedRestrictionWorkflows(spaceIdList));
            return contentRestrictionWorkflowRecordList;
        });
    }

    private void addCsvAsAttachmentToPage(AbstractPage page, String csv) throws IOException {
        SimpleDateFormat dateFormatterForFileName = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss");
        String fileName = "page_activity_" + page.getId() + "_" + dateFormatterForFileName.format(new Date()) + "_" + RandomStringUtils.random((int)8, (boolean)true, (boolean)false);
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Attachment attachment = new Attachment(fileName, "text/csv", (long)csv.getBytes().length, "");
        attachment.setCreator(confluenceUser);
        attachment.setCreationDate(new Date());
        attachment.setLastModificationDate(new Date());
        attachment.setContainer((ContentEntityObject)page);
        this.attachmentManager.saveAttachment(attachment, null, (InputStream)new ByteArrayInputStream(csv.getBytes()));
        page.addAttachment(attachment);
    }

    private String generateCsv(AbstractPage page) {
        ActivityReportOptions exportOptions = new ActivityReportOptions(false, false, false, false, false, false, Integer.MAX_VALUE);
        List<ActivityReportEntry> activityReportEntries = this.activityManager.getActivityReport(page, exportOptions);
        return this.pageActivityCsvService.getPageActivityFileContent(activityReportEntries, page, PageActivityCsvConfig.builder().skipOtherVersion(false).build());
    }

    private boolean hasWorkflowActive(Long pageId) {
        AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        log.debug("Checking if page {} has active workflow...", (Object)pageId);
        boolean hasPageWorkflow = this.adhocWorkflowManager.hasWorkflow(page);
        boolean hasSpaceWorkflow = this.workflowContainerManager.hasProductionWorkflows(page);
        State currentState = this.stateService.getCurrentState((ContentEntityObject)page);
        log.debug("Has page workflow {}, has space workflow {}, current state {}", new Object[]{hasPageWorkflow, hasSpaceWorkflow, currentState != null ? currentState.getName() : null});
        return hasSpaceWorkflow && currentState != null || hasPageWorkflow;
    }
}

