/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.randombits.confluence.filtering.criteria.AndCriteria;
import org.randombits.confluence.filtering.criteria.Criteria;
import org.randombits.confluence.filtering.criteria.CriteriaUtils;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.SourceCriterion;
import org.randombits.confluence.filtering.criteria.SourceCriterionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupCriteria
implements Criteria,
Iterable<Criterion>,
SourceCriterion<Object> {
    private static final SourceCriterionComparator COMPARATOR = new SourceCriterionComparator();
    private List<SourceCriterion<?>> sourceCriteria = new ArrayList();
    private List<Criterion> regularCriteria = new ArrayList<Criterion>();
    private boolean matchAll;
    private SourceCriterion.Weight weight = SourceCriterion.Weight.LIGHT;

    public GroupCriteria(boolean matchAll, Criterion ... criteria) {
        this.matchAll = matchAll;
        for (Criterion criterion : criteria) {
            this.addCriterion(criterion);
        }
    }

    @Override
    public void addCriterion(Criterion criterion) {
        if (criterion instanceof SourceCriterion) {
            SourceCriterion source = (SourceCriterion)criterion;
            this.sourceCriteria.add(source);
            this.weight = this.weight.compareTo(source.getWeight()) <= 0 ? this.weight : source.getWeight();
            Collections.sort(this.sourceCriteria, COMPARATOR);
        } else {
            this.regularCriteria.add(criterion);
        }
    }

    @Override
    public Collection<Criterion> getCriteria() {
        ArrayList<Criterion> allCriterion = new ArrayList<Criterion>();
        allCriterion.addAll(this.sourceCriteria);
        allCriterion.addAll(this.regularCriteria);
        return allCriterion;
    }

    @Override
    public boolean matches(Object object) {
        return this.matchesAll(object, this.sourceCriteria) && this.matchesAll(object, this.regularCriteria);
    }

    private boolean matchesAll(Object object, List<? extends Criterion> criteria) {
        for (Criterion criterion : criteria) {
            if (criterion.matches(object)) {
                if (this.matchAll) continue;
                return true;
            }
            if (!this.matchAll) continue;
            return false;
        }
        return this.matchAll || criteria.size() == 0;
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    @Override
    public Iterator<Criterion> iterator() {
        return this.getCriteria().iterator();
    }

    @Override
    public Collection<Object> getMatchingValues() {
        HashSet<Object> values = null;
        AndCriteria nullMatchers = null;
        if (!this.matchAll && this.regularCriteria.size() > 0) {
            return null;
        }
        for (SourceCriterion<?> source : this.sourceCriteria) {
            Collection<?> matches = source.getMatchingValues();
            if (matches == null) {
                if (this.matchAll) {
                    nullMatchers = this.addCriterion(nullMatchers, source);
                    continue;
                }
                return null;
            }
            if (values == null) {
                values = new HashSet<Object>(matches);
                continue;
            }
            if (this.matchAll) {
                values.retainAll(matches);
                if (values.size() != 0) continue;
                return values;
            }
            values.addAll(matches);
        }
        if (values != null && nullMatchers != null) {
            CriteriaUtils.filterCollectionContents(values, nullMatchers);
        }
        return values;
    }

    private AndCriteria addCriterion(AndCriteria nullMatchers, Criterion source) {
        if (nullMatchers == null) {
            nullMatchers = new AndCriteria(source);
        } else {
            nullMatchers.addCriterion(source);
        }
        return nullMatchers;
    }

    public String toString() {
        String join = null;
        StringBuilder out = new StringBuilder();
        out.append("( ");
        join = this.toStringCriteria(out, join, this.sourceCriteria);
        join = this.toStringCriteria(out, join, this.regularCriteria);
        out.append(" )");
        return out.toString();
    }

    private String toStringCriteria(StringBuilder out, String join, List<? extends Criterion> criteria) {
        for (Criterion criterion : criteria) {
            if (join == null) {
                join = this.matchAll ? " & " : " | ";
            } else {
                out.append(join);
            }
            out.append(criterion);
        }
        return join;
    }

    @Override
    public SourceCriterion.Weight getWeight() {
        return this.weight;
    }
}

