/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.restv2.model.report.RestSpaceReportColumn;
import com.comalatech.confluence.workflowreports.model.SpaceReportColumn;
import com.comalatech.confluence.workflowreports.model.SpaceWorkflowReportColumnsEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpaceReportSettings {
    private Map<String, SpaceReportColumn> settings;
    private static final List<SpaceWorkflowReportColumnsEnum> WORKFLOWS_DEFAULT_VISIBLE_COLUMNS = Arrays.asList(SpaceWorkflowReportColumnsEnum.TITLE, SpaceWorkflowReportColumnsEnum.UPDATEDBY, SpaceWorkflowReportColumnsEnum.UPDATED, SpaceWorkflowReportColumnsEnum.STATE, SpaceWorkflowReportColumnsEnum.DUEDATE);
    private static final List<SpaceWorkflowReportColumnsEnum> WORKFLOWS_DEFAULT_HIDDEN_COLUMNS = Arrays.asList(SpaceWorkflowReportColumnsEnum.WORKFLOW, SpaceWorkflowReportColumnsEnum.CHANGED, SpaceWorkflowReportColumnsEnum.CHANGEDBY, SpaceWorkflowReportColumnsEnum.LASTFINALVERSION, SpaceWorkflowReportColumnsEnum.LASTFINALVERSIONAPPROVERS, SpaceWorkflowReportColumnsEnum.LASTFINALVERSIONDATE, SpaceWorkflowReportColumnsEnum.APPROVALS, SpaceWorkflowReportColumnsEnum.READACKSTATUS);
    private static final List<SpaceWorkflowReportColumnsEnum> LITE_DEFAULT_VISIBLE_COLUMNS = Arrays.asList(SpaceWorkflowReportColumnsEnum.TITLE, SpaceWorkflowReportColumnsEnum.UPDATEDBY, SpaceWorkflowReportColumnsEnum.UPDATED, SpaceWorkflowReportColumnsEnum.STATE, SpaceWorkflowReportColumnsEnum.DUEDATE);
    private static final List<SpaceWorkflowReportColumnsEnum> LITE_DEFAULT_HIDDEN_COLUMNS = Arrays.asList(SpaceWorkflowReportColumnsEnum.WORKFLOW, SpaceWorkflowReportColumnsEnum.CHANGED, SpaceWorkflowReportColumnsEnum.CHANGEDBY, SpaceWorkflowReportColumnsEnum.LASTFINALVERSION, SpaceWorkflowReportColumnsEnum.LASTFINALVERSIONAPPROVERS, SpaceWorkflowReportColumnsEnum.LASTFINALVERSIONDATE, SpaceWorkflowReportColumnsEnum.APPROVALS, SpaceWorkflowReportColumnsEnum.READACKSTATUS);
    private static final List<SpaceWorkflowReportColumnsEnum> APPROVALS_DEFAULT_VISIBLE_COLUMNS = Arrays.asList(SpaceWorkflowReportColumnsEnum.TITLE, SpaceWorkflowReportColumnsEnum.UPDATEDBY, SpaceWorkflowReportColumnsEnum.UPDATED, SpaceWorkflowReportColumnsEnum.STATE, SpaceWorkflowReportColumnsEnum.APPROVALS);
    private static final List<SpaceWorkflowReportColumnsEnum> APPROVALS_DEFAULT_HIDDEN_COLUMNS = Arrays.asList(SpaceWorkflowReportColumnsEnum.CHANGED, SpaceWorkflowReportColumnsEnum.CHANGEDBY, SpaceWorkflowReportColumnsEnum.LASTFINALVERSION, SpaceWorkflowReportColumnsEnum.LASTFINALVERSIONAPPROVERS, SpaceWorkflowReportColumnsEnum.LASTFINALVERSIONDATE, SpaceWorkflowReportColumnsEnum.READACKSTATUS);

    public SpaceReportSettings() {
    }

    public SpaceReportSettings(Map<String, SpaceReportColumn> oldSettings, WorkflowsFeatureManager workflowsFeatureManager) {
        HashMap<String, SpaceReportColumn> newSettings = new HashMap<String, SpaceReportColumn>();
        Map<String, SpaceReportColumn> allSettings = this.getAllSettings(workflowsFeatureManager);
        for (SpaceReportColumn column : allSettings.values()) {
            if (oldSettings.containsKey(column.getKey())) {
                newSettings.put(column.getKey(), oldSettings.get(column.getKey()));
                continue;
            }
            newSettings.put(column.getKey(), new SpaceReportColumn(column.getKey(), false, allSettings.size() + column.getPosition()));
        }
        this.settings = newSettings;
    }

    public SpaceReportSettings(List<RestSpaceReportColumn> restSpaceReportColumns) {
        HashMap<String, SpaceReportColumn> settings = new HashMap<String, SpaceReportColumn>();
        for (int i = 0; i < restSpaceReportColumns.size(); ++i) {
            RestSpaceReportColumn restColumn = restSpaceReportColumns.get(i);
            settings.put(restColumn.key, new SpaceReportColumn(restColumn.key, restColumn.visible, i));
        }
        this.settings = settings;
    }

    public SpaceReportSettings(WorkflowsFeatureManager workflowsFeatureManager) {
        this.settings = this.getAllSettings(workflowsFeatureManager);
    }

    public List<RestSpaceReportColumn> getRestSettings() {
        ArrayList<RestSpaceReportColumn> restSpaceReportColumns = new ArrayList<RestSpaceReportColumn>();
        ArrayList<SpaceReportColumn> spaceReportColumnsList = new ArrayList<SpaceReportColumn>(this.settings.values());
        spaceReportColumnsList.sort(Comparator.comparing(SpaceReportColumn::getPosition));
        for (SpaceReportColumn storedColumn : spaceReportColumnsList) {
            restSpaceReportColumns.add(new RestSpaceReportColumn(storedColumn.getKey(), storedColumn.isVisible()));
        }
        return restSpaceReportColumns;
    }

    public Map<String, SpaceReportColumn> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, SpaceReportColumn> settings) {
        this.settings = settings;
    }

    private Map<String, SpaceReportColumn> getAllSettings(WorkflowsFeatureManager workflowsFeatureManager) {
        List<SpaceWorkflowReportColumnsEnum> hidden;
        List<SpaceWorkflowReportColumnsEnum> visible;
        HashMap<String, SpaceReportColumn> defaultSettings = new HashMap<String, SpaceReportColumn>();
        if (workflowsFeatureManager.isWorkflowsApp()) {
            visible = WORKFLOWS_DEFAULT_VISIBLE_COLUMNS;
            hidden = WORKFLOWS_DEFAULT_HIDDEN_COLUMNS;
        } else if (workflowsFeatureManager.isWorkflowsLiteApp()) {
            visible = LITE_DEFAULT_VISIBLE_COLUMNS;
            hidden = LITE_DEFAULT_HIDDEN_COLUMNS;
        } else {
            visible = APPROVALS_DEFAULT_VISIBLE_COLUMNS;
            hidden = APPROVALS_DEFAULT_HIDDEN_COLUMNS;
        }
        int count = 0;
        for (SpaceWorkflowReportColumnsEnum visibleColumn : visible) {
            defaultSettings.put(visibleColumn.getKey(), new SpaceReportColumn(visibleColumn.getKey(), true, count));
            ++count;
        }
        for (SpaceWorkflowReportColumnsEnum hiddenColumn : hidden) {
            defaultSettings.put(hiddenColumn.getKey(), new SpaceReportColumn(hiddenColumn.getKey(), false, count));
            ++count;
        }
        return defaultSettings;
    }
}

