/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.mappers;

import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.StateReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ColumnsParameterMapper
implements ParameterMapper {
    private static final String TITLE_COLUMN = "title";

    @Override
    public ReportParameter map(ReportParameter parameter) {
        if (this.parameterCanBeMapped(parameter)) {
            String columnsToShow = this.cleanColumnsValue(((StringReportParameterValue)parameter.getValue()).getValueOrDefault());
            StringBuilder columns = new StringBuilder();
            if (!columnsToShow.contains(TITLE_COLUMN)) {
                columns.append(TITLE_COLUMN).append(",").append(columnsToShow);
            } else {
                columns.append(columnsToShow);
            }
            parameter.setValue(new StringReportParameterValue(columns.toString(), columns.toString()));
        }
        return parameter;
    }

    @Override
    public boolean parameterCanBeMapped(ReportParameter parameter) {
        return parameter.keyIs(StateReportParameters.COLUMNS_TO_SHOW.getKey()) && parameter.getValue() instanceof StringReportParameterValue;
    }

    private String cleanColumnsValue(String columnsValue) {
        return Arrays.stream(columnsValue.split(",")).map(String::trim).filter(column -> !column.isEmpty()).collect(Collectors.joining(","));
    }
}

