/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rpc;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rpc.AuthenticationFailedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.xmlrpc.Translator;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.rpc.RemoteApprovalCheck;
import com.comalatech.confluence.workflow.rpc.WorkflowRpcHandler;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflowRpcHandler
implements WorkflowRpcHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowRpcHandler.class);
    private final ApprovalManager approvalManager;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final UserAccessor userAccessor;
    private final TransactionTemplate transactionTemplate;
    private final AttachmentManager attachmentManager;

    public DefaultWorkflowRpcHandler(ApprovalManager approvalManager, PageManager pageManager, PermissionManager permissionManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate, AttachmentManager attachmentManager) {
        this.approvalManager = approvalManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
        this.attachmentManager = attachmentManager;
    }

    public String login(String username, String password) throws AuthenticationFailedException, RemoteException {
        throw new RemoteException("this should be overriden by the API");
    }

    public boolean logout(String token) throws RemoteException {
        throw new RemoteException("this should be overriden by the API");
    }

    @Override
    public Hashtable approvePage(String token, final String remoteUser, final String spaceKey, final String pageName, final String approvalName, final String comment, final boolean approve, final String nextApprovers) throws RemoteException {
        return (Hashtable)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                Page page = DefaultWorkflowRpcHandler.this.pageManager.getPage(spaceKey, pageName);
                if (page == null) {
                    return DefaultWorkflowRpcHandler.this.makeHashtable(new RemoteApprovalCheck(spaceKey + ":" + pageName + " not found"));
                }
                return DefaultWorkflowRpcHandler.this.makeHashtable(DefaultWorkflowRpcHandler.this.approvePage((AbstractPage)page, approvalName, comment, approve, nextApprovers, remoteUser));
            }
        });
    }

    @Override
    public Hashtable approveBlogPost(String token, final String remoteUser, final String spaceKey, final Date postDate, final String postTitle, final String approvalName, final String comment, final boolean approve, final String nextApprovers) throws RemoteException {
        return (Hashtable)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                BlogPost post = DefaultWorkflowRpcHandler.this.pageManager.getBlogPost(spaceKey, postTitle, BlogPost.toCalendar((Date)postDate));
                if (post == null) {
                    return DefaultWorkflowRpcHandler.this.makeHashtable(new RemoteApprovalCheck(spaceKey + BlogPost.toDatePath((Date)postDate) + "/" + postTitle + " not found"));
                }
                return DefaultWorkflowRpcHandler.this.makeHashtable(DefaultWorkflowRpcHandler.this.approvePage((AbstractPage)post, approvalName, comment, approve, nextApprovers, remoteUser));
            }
        });
    }

    private Hashtable makeHashtable(RemoteApprovalCheck remoteApprovalCheck) {
        return Translator.makeStruct((Object)remoteApprovalCheck);
    }

    private RemoteApprovalCheck approvePage(AbstractPage page, String approvalName, String comment, boolean approve, String nextApprovers, String userName) {
        if (log.isDebugEnabled()) {
            log.debug("will approve " + page + " approvalName:" + approvalName + " comment:" + comment + " approve:" + approve + " nextApprovers:" + nextApprovers + " userName:" + userName);
        }
        try {
            ConfluenceUser user = this.userAccessor.getUserByName(userName);
            if (user == null) {
                throw new WorkflowException("invalid user name" + userName);
            }
            if (!this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page)) {
                throw new WorkflowException(user.getName() + " has not editing permission on " + page);
            }
            ApprovalCheck check = this.approvalManager.approvePage(page, approvalName, approve, comment, user, false, false, false, false);
            return new RemoteApprovalCheck(page, check, this.makeAttachmentChecks(page, check));
        }
        catch (WorkflowException e) {
            log.error("", (Throwable)e);
            return new RemoteApprovalCheck(e.getMessage());
        }
    }

    public Vector makeAttachmentChecks(AbstractPage page, ApprovalCheck approvalCheck) {
        Vector checks = new Vector();
        if (approvalCheck.getAttachments() == null) {
            return checks;
        }
        List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page);
        Collections.sort(attachments, new Comparator(){

            public int compare(Object o, Object o1) {
                Attachment a = (Attachment)o;
                Attachment a1 = (Attachment)o1;
                if (a.getId() < a1.getId()) {
                    return -1;
                }
                if (a.getId() > a1.getId()) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < approvalCheck.getAttachments().length; ++i) {
            ApprovalCheck.CheckedAttachment checkedAttachment = approvalCheck.getAttachments()[i];
            int ix = Collections.binarySearch(attachments, new Long(checkedAttachment.getId()), new Comparator(){

                public int compare(Object o, Object o1) {
                    Attachment a = (Attachment)o;
                    long l = (Long)o1;
                    if (a.getId() < l) {
                        return -1;
                    }
                    if (a.getId() > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (ix < 0) continue;
            checks.add(attachments.get(ix));
        }
        return checks;
    }
}

