/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflow.restv2.model.RestTrigger;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;

public class TriggerMapper
implements Mapper<Trigger, RestTrigger> {
    @Override
    public RestTrigger toRest(Trigger trigger) {
        RestTrigger restTrigger = new RestTrigger();
        restTrigger.queue = trigger.isQueue() ? Boolean.valueOf(true) : null;
        restTrigger.newEvent = trigger.getNewEvent();
        restTrigger.event = Mappers.eventMapper.toRest(trigger.getEvent());
        restTrigger.description = trigger.getDescription();
        if (trigger.getConditions() != null && trigger.getConditions().size() > 0) {
            restTrigger.conditions = trigger.getConditions().stream().map(Mappers.conditionMapper::toRest).filter(Objects::nonNull).collect(Collectors.toList());
        }
        restTrigger.actions = trigger.getFormatedAction();
        return restTrigger;
    }

    @Override
    public Trigger fromRest(RestTrigger restTrigger) {
        ConfluenceEvent event = Mappers.eventMapper.fromRest(restTrigger.event);
        String name = Mappers.eventMapper.toMacroName(event);
        List<Condition> conditions = null;
        if (restTrigger.conditions != null) {
            conditions = restTrigger.conditions.stream().map(Mappers.conditionMapper::fromRest).collect(Collectors.toList());
        }
        Trigger trigger = new Trigger(event, true, name, conditions, restTrigger.actions, BooleanUtils.isTrue((Boolean)restTrigger.queue), restTrigger.newEvent, restTrigger.description);
        try {
            trigger.validate();
        }
        catch (WorkflowException e) {
            throw new MapperException("Error validating trigger at fromRest(restTrigger)", e);
        }
        return trigger;
    }
}

