/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;

public class IsValueAsUserSetCondition
extends Condition {
    public static final String PARAM_NAME = "usersdefined";
    private String[] valueNames;

    public IsValueAsUserSetCondition(boolean not, String valueNames) {
        super(not);
        this.valueNames = MiscUtils.splitAndTrim(valueNames);
    }

    public String[] getValueNames() {
        return this.valueNames;
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter(PARAM_NAME, (Object)((this.not ? "!" : "") + MiscUtils.listToString(this.valueNames)));
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        try {
            String[] users = this.getUsersListResolver().getValueAsUserNames(valueStore, valueStore.getPage(), String.join((CharSequence)",", this.valueNames), false);
            return users.length > 0;
        }
        catch (WorkflowException e) {
            return false;
        }
    }

    @Override
    public String toString(ValueStore valueStore) {
        return MiscUtils.listToString(this.valueNames) + (this.not ? "does not " : "") + " have/has users set";
    }
}

