/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.helpers;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.util.PageReference;
import com.comalatech.confluence.util.RenderUtils;
import com.comalatech.confluence.workflow.helpers.TemplateRenderer;

public class DefaultTemplateRenderer
implements TemplateRenderer {
    private final WikiStyleRenderer wikiStyleRenderer;
    private final PageTemplateManager pageTemplateManager;
    private final SpaceManager spaceManager;

    public DefaultTemplateRenderer(WikiStyleRenderer wikiStyleRenderer, PageTemplateManager pageTemplateManager, SpaceManager spaceManager) {
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.pageTemplateManager = pageTemplateManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public String renderTemplate(PageTemplate pageTemplate, RenderContext renderContext) {
        return RenderUtils.renderContent(pageTemplate, renderContext);
    }

    @Override
    public PageTemplate getTemplate(PageReference pageReference, String defaultSpaceKey) {
        Object space = null;
        if (pageReference.getSpaceKey() != null) {
            space = this.spaceManager.getSpace(pageReference.getSpaceKey());
        }
        if (space == null) {
            space = defaultSpaceKey == null ? null : this.spaceManager.getSpace(defaultSpaceKey);
        }
        return this.pageTemplateManager.getPageTemplate(pageReference.getPageName(), space);
    }

    public String render(String body, RenderContext renderContext) {
        return this.wikiStyleRenderer.convertWikiToXHtml(renderContext, body);
    }
}

