/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.license;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.LicenseStatus;
import com.comalatech.confluence.license.PluginLicenseStatus;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import java.net.URI;
import java.util.Date;
import org.joda.time.DateTime;

public class MarketplaceAdhocWorkflowsLicenseManager
implements AdhocWorkflowsLicenseManager {
    private final PluginLicenseManager licenseManager;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final DarkFeatureManager darkFeatureManager;
    public static long ABOUT_TO_EXPIRE_OFFSET_MS = 432000000L;

    public MarketplaceAdhocWorkflowsLicenseManager(PluginLicenseManager licenseManager, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, WorkflowsFeatureManager workflowsFeatureManager, DarkFeatureManager darkFeatureManager) {
        this.licenseManager = licenseManager;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public boolean isLicensed() {
        PluginLicenseStatus licenseStatus = this.getLicenseStatus();
        return licenseStatus != null && (licenseStatus.getStatus() == LicenseStatus.LICENSE_STATUS_OK || licenseStatus.getStatus() == LicenseStatus.LICENSE_STATUS_EVALUATION);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PluginLicenseStatus getLicenseStatus() {
        if (!this.licenseManager.getLicense().isDefined()) return this.makeLicenseStatus(LicenseStatus.LICENSE_STATUS_INVALID_LICENSE);
        PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
        if (pluginLicense.getError().isDefined()) {
            LicenseError licenseError = (LicenseError)pluginLicense.getError().get();
            if (licenseError == null) return null;
            switch (licenseError) {
                case VERSION_MISMATCH: {
                    return this.makeLicenseStatus(LicenseStatus.LICENSE_STATUS_UPDATES_EXPIRED);
                }
                case USER_MISMATCH: {
                    return this.makeLicenseStatus(LicenseStatus.LICENSE_STATUS_TOO_MANY_USERS);
                }
                case EXPIRED: {
                    return this.makeLicenseStatus(pluginLicense.isEvaluation() ? LicenseStatus.LICENSE_STATUS_TRIAL_EXPIRED : LicenseStatus.LICENSE_STATUS_EXPIRED);
                }
            }
            return this.makeLicenseStatus(LicenseStatus.LICENSE_STATUS_INVALID_LICENSE);
        }
        if (pluginLicense.isEvaluation()) {
            return this.makeLicenseStatus(LicenseStatus.LICENSE_STATUS_EVALUATION);
        }
        if (!pluginLicense.isValid()) return this.makeLicenseStatus(LicenseStatus.LICENSE_STATUS_INVALID_LICENSE);
        return this.makeLicenseStatus(LicenseStatus.LICENSE_STATUS_OK);
    }

    public PluginLicenseStatus makeLicenseStatus(LicenseStatus status) {
        PluginLicenseStatus pluginLicenseStatus = new PluginLicenseStatus(status);
        String upmUrl = this.getLicenseUrl();
        if (status != null) {
            switch (status) {
                case LICENSE_STATUS_EVALUATION: {
                    PluginLicense license;
                    pluginLicenseStatus.setMessageHtml("");
                    if (!this.licenseManager.getLicense().isDefined() || !this.isAboutToExpire(license = (PluginLicense)this.licenseManager.getLicense().get())) break;
                    int days = this.getDaysLeft(license);
                    if (days > 0) {
                        pluginLicenseStatus.setMessageHtml(this.getText("adhocworkflows.mp.license.abouttoexpire", Integer.toString(days), upmUrl));
                        break;
                    }
                    pluginLicenseStatus.setMessageHtml(this.getText("adhocworkflows.mp.license.abouttoexpire.0", upmUrl));
                    break;
                }
                case LICENSE_STATUS_TOO_MANY_USERS: {
                    pluginLicenseStatus.setMessageHtml(this.getText(status.getMessageKey(), Integer.toString(this.getLicensedUsers()), Integer.toString(this.getLicensedConfluenceUsers()), upmUrl));
                    break;
                }
                case LICENSE_STATUS_UPDATES_EXPIRED: {
                    pluginLicenseStatus.setMessageHtml(this.getText(status.getMessageKey(), this.getPluginVersion(), upmUrl));
                    break;
                }
                default: {
                    pluginLicenseStatus.setMessageHtml(this.getText(status.getMessageKey(), upmUrl));
                }
            }
        }
        return pluginLicenseStatus;
    }

    @Override
    public PluginLicenseStatus getLicenseStatus(int workflows, boolean forceCheck) {
        return this.getLicenseStatus();
    }

    @Override
    public LicenseType getLicenseType() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return pluginLicense.getLicenseType();
        }
        return null;
    }

    public int getLicensedConfluenceUsers() {
        License license = LicenseManager.getInstance().getLicense("CONF");
        return license.getUsers();
    }

    private String getPluginVersion() {
        return this.pluginAccessor.getEnabledPlugin(this.workflowsFeatureManager.getPluginKey()).getPluginInformation().getVersion();
    }

    private int getLicensedUsers() {
        if (this.licenseManager.getLicense().isDefined()) {
            return (Integer)((PluginLicense)this.licenseManager.getLicense().get()).getMaximumNumberOfUsers().get();
        }
        return 0;
    }

    private String getText(String key, String ... params) {
        return ConfluenceActionSupport.getTextStatic((String)key, (Object[])params);
    }

    private String getLicenseUrl() {
        String pluginKey = this.licenseManager.getPluginKey();
        return URI.create(this.applicationProperties.getBaseUrl() + "/plugins/servlet/upm?fragment=manage/" + pluginKey).normalize().toString();
    }

    private boolean isAboutToExpire(PluginLicense license) {
        return license != null && ((DateTime)license.getExpiryDate().get()).getMillis() - ABOUT_TO_EXPIRE_OFFSET_MS <= this.now().getTime();
    }

    public int getDaysLeft(PluginLicense license) {
        long msLeft = ((DateTime)license.getExpiryDate().get()).getMillis() - this.now().getTime();
        return (int)(msLeft / (ABOUT_TO_EXPIRE_OFFSET_MS / 5L));
    }

    private Date now() {
        return new Date();
    }
}

