/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.domain.entities.Target;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import org.apache.commons.lang3.StringUtils;

public class ApprovalsMapper {
    private final ActorUtils actorUtils;
    private final PageManager pageManager;

    public ApprovalsMapper(PageManager pageManager, ActorUtils actorUtils) {
        this.pageManager = pageManager;
        this.actorUtils = actorUtils;
    }

    public Activity buildApprovalOrRejectionActivity(PageState pageState, ApprovalCheck approvalCheck, Approver approver) {
        long moment = approver.getDate().getTime();
        Target target = this.mapContent(pageState, approvalCheck);
        Actor actor = this.mapPerformer(approver);
        ActionType actionType = this.mapAction(approver);
        Action action = this.mapApprovalOrRejection(actionType, actor, approver);
        return new Activity(target, moment, action);
    }

    private Actor mapPerformer(Approver approver) {
        return this.actorUtils.buildActor(approver.getUserName(), true);
    }

    private Target mapContent(PageState pageState, ApprovalCheck approvalCheck) {
        Target target = new Target();
        AbstractPage page = pageState.getPage();
        ContentEntityObject content = this.pageManager.getOtherVersion((ContentEntityObject)page, approvalCheck.getVersion());
        target.setTargetId(content.getId());
        target.setTargetVersion(approvalCheck.getVersion());
        target.setSpaceKey(page.getSpaceKey());
        return target;
    }

    private ActionType mapAction(Approver approver) {
        ActionType actionType = new ActionType();
        if (approver.isApproved()) {
            actionType.setType(ActionType.Type.APPROVAL);
            actionType.setSubtype(ActionType.Subtype.APPROVAL_APPROVED);
        } else {
            actionType.setType(ActionType.Type.APPROVAL);
            actionType.setSubtype(ActionType.Subtype.APPROVAL_REJECTED);
        }
        return actionType;
    }

    private Action mapApprovalOrRejection(ActionType actionType, Actor actor, Approver approver) {
        Action action = new Action();
        action.setActionType(actionType);
        action.setActor(actor);
        action.setActionDetails(this.mapActionDetails(approver));
        return action;
    }

    private ActionDetails mapActionDetails(Approver approver) {
        ActionDetails actionDetails = new ActionDetails();
        if (!StringUtils.isEmpty((CharSequence)approver.getComment())) {
            actionDetails.addDetail(ActionDetail.Type.APPROVAL_COMMENT, approver.getComment());
        }
        return actionDetails;
    }
}

