/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.util;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.BitSet;
import org.randombits.util.ABitSet;
import org.randombits.util.IOUtils;
import org.randombits.util.TextBuffer;

public class TokenIterator {
    public static final BitSet ALL_CHARS = new ABitSet(65535, true);
    public static final int UNBOUNDED = Integer.MAX_VALUE;
    protected CharacterIterator chars;
    protected int lastIndex = 0;

    public TokenIterator(Reader reader) throws IOException {
        BufferedReader in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        CharArrayWriter writer = new CharArrayWriter();
        IOUtils.pipe(in, writer);
        this.chars = new StringCharacterIterator(writer.toString());
    }

    public TokenIterator(CharacterIterator chars) {
        this.chars = chars;
        this.lastIndex = chars.getBeginIndex();
    }

    public TokenIterator(String string) {
        this(new StringCharacterIterator(string));
    }

    public CharSequence getSequence(BitSet charSet, String terminator) {
        TextBuffer buff = new TextBuffer();
        while (!this.matchToken(terminator)) {
            char ch = this.chars.current();
            if (ch == '\uffff' || !charSet.get(ch)) {
                return null;
            }
            buff.add(ch);
            this.chars.next();
        }
        return buff;
    }

    public CharSequence getSequence(BitSet charSet) {
        return this.getSequence(charSet, 0, Integer.MAX_VALUE);
    }

    public CharSequence getSequence(BitSet charSet, int min) {
        return this.getSequence(charSet, min, Integer.MAX_VALUE);
    }

    public CharSequence getSequence(BitSet charSet, int min, int max) {
        char ch;
        int count;
        TextBuffer buff = new TextBuffer();
        int mark = this.chars.getIndex();
        for (count = 0; count < max && (ch = this.chars.current()) != '\uffff' && charSet.get(ch); ++count) {
            buff.add(ch);
            this.chars.next();
        }
        if (count < min) {
            this.chars.setIndex(mark);
            return null;
        }
        this.lastIndex = mark;
        return buff;
    }

    public boolean matchToken(String token) {
        int mark = this.chars.getIndex();
        boolean match = this.getToken(token) != null;
        this.chars.setIndex(mark);
        return match;
    }

    public boolean matchToken(int ch) {
        char read = this.chars.current();
        return read == ch;
    }

    public CharSequence getToken(String token) {
        return this.getToken(token, false);
    }

    public CharSequence getToken(String token, boolean ignoreCase) {
        int mark = this.chars.getIndex();
        int length = token.length();
        TextBuffer buff = new TextBuffer();
        for (int i = 0; i < length; ++i) {
            int tok = this.getChar(token.charAt(i), ignoreCase);
            if (tok == 65535) {
                this.chars.setIndex(mark);
                return null;
            }
            buff.add((char)tok);
        }
        this.lastIndex = mark;
        return buff;
    }

    public CharSequence getToken(int ch) {
        return this.getToken(ch, false);
    }

    public CharSequence getToken(int ch, boolean ignoreCase) {
        int mark = this.chars.getIndex();
        int tok = this.getChar(ch, ignoreCase);
        if (tok == 65535) {
            this.chars.setIndex(mark);
            return null;
        }
        this.lastIndex = mark;
        return String.valueOf((char)tok);
    }

    private int getChar(int ch, boolean ignoreCase) {
        char ch_in = this.chars.current();
        if (ignoreCase && Character.toLowerCase((char)ch) != Character.toLowerCase(ch_in) || !ignoreCase && ch != ch_in) {
            return 65535;
        }
        this.chars.next();
        return ch_in;
    }

    public void rewind() {
        this.chars.setIndex(this.lastIndex);
    }

    public boolean atEnd() {
        return this.chars.getIndex() == this.chars.getEndIndex();
    }

    public boolean atBeginning() {
        return this.chars.getIndex() == this.chars.getBeginIndex();
    }

    public String toString() {
        return this.chars.toString();
    }

    static {
        ((ABitSet)ALL_CHARS).setRange(0, 65535);
        ((ABitSet)ALL_CHARS).lock();
    }
}

