/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage.param;

import java.util.regex.Pattern;
import org.randombits.storage.param.Parameter;
import org.randombits.storage.param.ParameterParsingException;
import org.randombits.storage.param.ParameterStorage;
import org.randombits.storage.param.StringParameterStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterParser {
    private final char escape;
    private final char paramSeparator;
    private final char assignmentSeparator;
    private final Pattern paramSplitter;
    private final Pattern assignmentSplitter;
    private final Pattern escapePattern;
    private final boolean unescapedAssignmentAllowed;

    public ParameterParser(char assignmentSeparator, char paramSeparator, char escape) {
        this(assignmentSeparator, paramSeparator, escape, true);
    }

    public ParameterParser(char assignmentSeparator, char paramSeparator, char escape, boolean unescapedAssignmentAllowed) {
        this.escape = escape;
        this.paramSeparator = paramSeparator;
        this.assignmentSeparator = assignmentSeparator;
        this.unescapedAssignmentAllowed = unescapedAssignmentAllowed;
        this.paramSplitter = ParameterParser.compileEscapedSplitter(escape, paramSeparator);
        this.assignmentSplitter = ParameterParser.compileEscapedSplitter(escape, assignmentSeparator);
        this.escapePattern = Pattern.compile("\\" + escape + "(.)");
    }

    public static Pattern compileEscapedSplitter(char escape, char separator) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("(?<!(^|[^\\").append(escape).append("])").append("(\\").append(escape).append('\\').append(escape).append("){0,100}\\").append(escape).append(")\\").append(separator);
        return Pattern.compile(pattern.toString());
    }

    public ParameterStorage<String> parseList(String parameterList) throws ParameterParsingException {
        return this.parseList(parameterList, false);
    }

    public ParameterStorage<String> parseList(String parameterList, boolean requireKey) throws ParameterParsingException {
        StringParameterStorage storage = new StringParameterStorage();
        if (parameterList != null && parameterList.length() > 0) {
            String[] paramsArray = this.paramSplitter.split(parameterList);
            int index = requireKey ? -1 : 0;
            for (String paramValue : paramsArray) {
                Parameter<String> param = this.parseParameter(paramValue, index < 0);
                if (param.getKey() == null) {
                    param.setKey(String.valueOf(index));
                    ++index;
                } else {
                    index = -1;
                }
                storage.add(param);
            }
        }
        return storage;
    }

    public Parameter<String> parseParameter(String parameter) throws ParameterParsingException {
        return this.parseParameter(parameter, true);
    }

    public Parameter<String> parseParameter(String parameter, boolean requireKey) throws ParameterParsingException {
        String value;
        String key;
        String[] paramArray = this.assignmentSplitter.split(parameter, this.unescapedAssignmentAllowed ? 2 : -1);
        if (paramArray.length == 1) {
            key = null;
            value = paramArray[0];
        } else if (paramArray.length == 2) {
            key = paramArray[0].trim();
            value = paramArray[1];
        } else {
            throw new ParameterParsingException("Invalid parameter: " + parameter);
        }
        key = this.unescape(key);
        value = this.unescape(value);
        if (key == null || key.length() == 0) {
            if (requireKey) {
                throw new ParameterParsingException("Unexpected unnamed parameter: " + parameter);
            }
            key = null;
        }
        return new Parameter<String>(key, value);
    }

    private String unescape(String string) {
        if (string != null) {
            return this.escapePattern.matcher(string).replaceAll("$1");
        }
        return null;
    }

    public char getEscape() {
        return this.escape;
    }

    public char getParamSeparator() {
        return this.paramSeparator;
    }

    public char getAssignmentSeparator() {
        return this.assignmentSeparator;
    }

    public boolean isUnescapedAssignmentAllowed() {
        return this.unescapedAssignmentAllowed;
    }
}

