/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.support;

import com.atlassian.user.User;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.randombits.confluence.support.DWRServletProvider;
import org.randombits.confluence.support.ServletProvider;
import org.randombits.confluence.support.XWorkServletProvider;

public final class ServletAssistant {
    private static final ServletAssistant INSTANCE = new ServletAssistant();
    private List<ServletProvider> servletProviders = new ArrayList<ServletProvider>(5);

    public static ServletAssistant getInstance() {
        return INSTANCE;
    }

    private ServletAssistant() {
        this.registerServletProvider(new XWorkServletProvider());
        this.registerServletProvider(new DWRServletProvider());
    }

    public void registerServletProvider(ServletProvider provider) {
        this.servletProviders.add(provider);
    }

    public User getCurrentUser() {
        return (User)this.fetch(new Fetcher(){

            public Object fetch(ServletProvider info) {
                return info.getCurrentUser();
            }
        });
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.fetch(new Fetcher(){

            public Object fetch(ServletProvider info) {
                return info.getRequest();
            }
        });
    }

    public MultiPartRequestWrapper getMultiPartRequest() {
        HttpServletRequest req = this.getRequest();
        if (req instanceof MultiPartRequestWrapper) {
            return (MultiPartRequestWrapper)req;
        }
        return null;
    }

    private Object fetch(Fetcher fetcher) {
        for (ServletProvider provider : this.servletProviders) {
            Object fetched = fetcher.fetch(provider);
            if (fetched == null) continue;
            return fetched;
        }
        return null;
    }

    public HttpServletResponse getResponse() {
        return (HttpServletResponse)this.fetch(new Fetcher(){

            public Object fetch(ServletProvider info) {
                return info.getResponse();
            }
        });
    }

    public ServletConfig getServletConfig() {
        return (ServletConfig)this.fetch(new Fetcher(){

            public Object fetch(ServletProvider info) {
                return info.getServletConfig();
            }
        });
    }

    public ServletContext getServletContext() {
        return (ServletContext)this.fetch(new Fetcher(){

            public Object fetch(ServletProvider info) {
                return info.getServletContext();
            }
        });
    }

    public HttpSession getSession() {
        return (HttpSession)this.fetch(new Fetcher(){

            public Object fetch(ServletProvider info) {
                return info.getSession();
            }
        });
    }

    public String getFullPath(String webappRelativePath) {
        if (webappRelativePath == null) {
            return null;
        }
        HttpServletRequest req = this.getRequest();
        if (req != null) {
            return req.getContextPath() + webappRelativePath;
        }
        return webappRelativePath;
    }

    private static interface Fetcher {
        public Object fetch(ServletProvider var1);
    }
}

