/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.states.model.StateChangeReason;
import com.comalatech.confluence.util.CSVBuilder;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvProcessor;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityEntryProcessor;
import com.comalatech.workflow.model.SignatureType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class PageActivityCsvEntryProcessorAO
extends PageActivityCsvProcessor {
    private final PageManager pageManager;
    private final ReportDateFormatter dateFormatter;

    public PageActivityCsvEntryProcessorAO(PageManager pageManager, ReportDateFormatter dateFormatter, I18nResolver i18nResolver) {
        super(i18nResolver);
        this.pageManager = pageManager;
        this.dateFormatter = dateFormatter;
    }

    @Override
    public <E> void processEntry(CSVBuilder csv, AbstractPage page, E entry) {
        long version;
        Activity activity = (Activity)entry;
        String formattedDate = this.dateFormatter.formatServerDateTimePrecise(new Date(activity.getMoment()));
        csv.addCell(formattedDate);
        List<Actor> actors = activity.getAction().getActors();
        List<String> usernames = actors.stream().anyMatch(actor -> "com.comalatech.anonymous".equals(actor.getName())) ? Collections.singletonList(this.getTextStatic("com.comalatech.activity.report.csvexport.anonymous")) : actors.stream().map(Actor::getName).collect(Collectors.toList());
        csv.addCell(usernames.get(0));
        if (ActionType.Type.PAGE.equals((Object)activity.getAction().getActionType().getType())) {
            csv.addCell(String.join((CharSequence)",", usernames));
        } else {
            csv.addCell("");
        }
        switch (activity.getAction().getActionType().getType()) {
            case PAGE: 
            case COMMENT: {
                this.addPageFileContent(csv, activity);
                break;
            }
            case APPROVAL: {
                this.addApprovalFileContent(csv, activity);
                break;
            }
            case STATE: {
                this.addStateFileContent(csv, activity);
                break;
            }
            case TASK: {
                this.addTaskFileContent(csv, activity);
                break;
            }
            case READ_CONFIRMATION: {
                this.addReadAckFileContent(csv, activity);
            }
        }
        String versionStr = "";
        String oldPageId = "";
        if (activity.getTarget() != null && (version = (long)activity.getTarget().getTargetVersion()) != -1L) {
            ContentEntityObject oldPage;
            versionStr = String.valueOf(version);
            if (!this.isSkipOtherVersion() && (oldPage = this.pageManager.getOtherVersion((ContentEntityObject)page, (int)version)) != null) {
                oldPageId = String.valueOf(oldPage.getId());
            }
        }
        csv.addCell("v" + versionStr);
        csv.addCell(oldPageId);
        ArrayList<String> comments = new ArrayList<String>();
        if (activity.getAction() != null && activity.getAction().getActionDetails() != null) {
            for (ActionDetail actionDetail : activity.getAction().getActionDetails()) {
                switch (actionDetail.getType()) {
                    case STATE_COMMENT: 
                    case APPROVAL_COMMENT: 
                    case TASK_COMMENT: 
                    case TASK_DESCRIPTION: 
                    case PAGE_COMMENT: 
                    case PAGE_VERSION_COMMENT: {
                        comments.add(actionDetail.getValue());
                    }
                }
            }
        }
        csv.addCell(comments.stream().collect(Collectors.joining(",")));
        csv.newLine();
    }

    private void addPageFileContent(CSVBuilder csv, Activity activity) {
        if (activity.getAction().getActionType().getType() == ActionType.Type.COMMENT) {
            csv.addCell("comment");
            csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.commented", new String[]{this.getFormattedDate(activity)})));
        } else {
            switch (activity.getAction().getActionType().getSubtype()) {
                case PAGE_CREATED: {
                    csv.addCell("modification");
                    csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.created", new String[]{this.getFormattedDate(activity)})));
                    break;
                }
                case PAGE_UPDATED: {
                    csv.addCell("modification");
                    csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.modified", new String[]{this.getFormattedDate(activity)})));
                }
            }
        }
    }

    private void addApprovalFileContent(CSVBuilder csv, Activity activity) {
        ActionDetails details = activity.getAction().getActionDetails();
        String role = details.getDetail(ActionDetail.Type.APPROVAL_ROLE).getValue();
        switch (activity.getAction().getActionType().getSubtype()) {
            case APPROVAL_APPROVED: {
                csv.addCell("approval");
                if (role != null) {
                    csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.approved.role", new String[]{details.getDetailValue(ActionDetail.Type.APPROVAL_NAME), this.getFormattedDate(activity), this.getSignatureMode(details), role})));
                    break;
                }
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.approved", new String[]{details.getDetailValue(ActionDetail.Type.APPROVAL_NAME), this.getFormattedDate(activity), this.getSignatureMode(details)})));
                break;
            }
            case APPROVAL_REJECTED: {
                csv.addCell("approval");
                if (role != null) {
                    csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.rejected.role", new String[]{details.getDetailValue(ActionDetail.Type.APPROVAL_NAME), this.getFormattedDate(activity), this.getSignatureMode(details), role})));
                    break;
                }
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.rejected", new String[]{details.getDetailValue(ActionDetail.Type.APPROVAL_NAME), this.getFormattedDate(activity), this.getSignatureMode(details)})));
                break;
            }
            case APPROVAL_ASSIGNED: {
                List<Actor> assignees = details.getDetailParticipants(ActionDetail.Type.APPROVAL_USER_ASSIGNED);
                String assigneesNames = assignees.stream().map(Actor::getName).collect(Collectors.joining(","));
                if (assigneesNames.contains("com.comalatech.anonymous")) {
                    assigneesNames = assigneesNames.replace("com.comalatech.anonymous", this.getTextStatic("com.comalatech.activity.report.csvexport.anonymous"));
                }
                csv.addCell("approval-assignment");
                if (role != null) {
                    csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.assigned.role", new String[]{details.getDetailValue(ActionDetail.Type.APPROVAL_NAME), assigneesNames, this.getFormattedDate(activity), role})));
                    break;
                }
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.assigned", new String[]{details.getDetailValue(ActionDetail.Type.APPROVAL_NAME), assigneesNames, this.getFormattedDate(activity)})));
                break;
            }
            case APPROVAL_UNASSIGNED: {
                List<Actor> unassignees = details.getDetailParticipants(ActionDetail.Type.APPROVAL_USER_UNASSIGNED);
                String unassigneesNames = unassignees.stream().map(Actor::getName).collect(Collectors.joining(","));
                if (unassigneesNames.contains("com.comalatech.anonymous")) {
                    unassigneesNames = unassigneesNames.replace("com.comalatech.anonymous", this.getTextStatic("com.comalatech.activity.report.csvexport.anonymous"));
                }
                csv.addCell("approval-unassignment");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.approval.unassigned", new String[]{details.getDetailValue(ActionDetail.Type.APPROVAL_NAME), unassigneesNames, this.getFormattedDate(activity)})));
            }
        }
    }

    private void addStateFileContent(CSVBuilder csv, Activity activity) {
        ActionDetails details = activity.getAction().getActionDetails();
        switch (activity.getAction().getActionType().getSubtype()) {
            case STATE_TRANSITION: {
                csv.addCell("state");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.changed-state", new String[]{details.getDetailValue(ActionDetail.Type.STATE_NAME), this.getFormattedDate(activity)})));
                break;
            }
            case STATE_OVERRIDE: {
                csv.addCell("state");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.changed-state", new String[]{details.getDetailValue(ActionDetail.Type.STATE_NAME), this.getFormattedDate(activity)}) + " (" + this.getTextStatic(StateChangeReason.ADMIN_OVERRIDE.getI18nName()) + ")"));
                break;
            }
            case STATE_INIT: {
                csv.addCell("state");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.changed-state", new String[]{details.getDetailValue(ActionDetail.Type.STATE_NAME), this.getFormattedDate(activity)}) + " (" + this.getTextStatic(StateChangeReason.SPACE_INITIALISE.getI18nName()) + ")"));
                break;
            }
            case STATE_EXPIRED: {
                csv.addCell("duedaterecordexpiry");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.state-expired", new String[]{details.getDetailValue(ActionDetail.Type.STATE_NAME), this.getFormattedDate(activity)})));
                break;
            }
            case STATE_EXPIRY_UPDATE: {
                csv.addCell("duedaterecord");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.state", new String[]{details.getDetailValue(ActionDetail.Type.STATE_NAME), this.getFormattedDueDate(new Date(Long.parseLong(details.getDetailValue(ActionDetail.Type.NEW_EXPIRY_DATE)))), this.getFormattedDate(activity)})));
                break;
            }
            case STATE_EXPIRY_REMOVED: {
                csv.addCell("duedaterecord");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.state.remove", new String[]{details.getDetailValue(ActionDetail.Type.STATE_NAME), this.getFormattedDate(activity)})));
            }
        }
    }

    private void addTaskFileContent(CSVBuilder csv, Activity activity) {
        ActionDetails details = activity.getAction().getActionDetails();
        String taskName = "'" + details.getDetailValue(ActionDetail.Type.TASK_NAME) + "'";
        switch (activity.getAction().getActionType().getSubtype()) {
            case TASK_ASSIGNMENT: {
                List<Actor> assignees = details.getDetailParticipants(ActionDetail.Type.TASK_USER_ASSIGNED);
                String assigneesNames = assignees.stream().map(Actor::getName).collect(Collectors.joining(","));
                csv.addCell("assignment");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.assigned", new String[]{taskName, assigneesNames, this.getFormattedDate(activity)})));
                break;
            }
            case TASK_UNASSIGNMENT: {
                csv.addCell("assignment");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.unassigned", new String[]{taskName, this.getFormattedDate(activity)})));
                break;
            }
            case TASK_COMPLETION: {
                csv.addCell("completion");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.completed", new String[]{taskName, this.getFormattedDate(activity)})));
                break;
            }
            case TASK_CREATION: {
                csv.addCell("task");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.created", new String[]{taskName, this.getFormattedDate(activity)})));
                break;
            }
            case TASK_UPDATE: {
                csv.addCell("taskupdate");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.updated", new String[]{taskName, this.getFormattedDate(activity)})));
                break;
            }
            case TASK_DELETION: {
                csv.addCell("deletion");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.task.deleted", new String[]{taskName, this.getFormattedDate(activity)})));
                break;
            }
            case TASK_DUE_DATE: {
                csv.addCell("duedaterecord");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.task", new String[]{taskName, this.getFormattedDueDate(new Date(Long.parseLong(details.getDetailValue(ActionDetail.Type.TASK_DUE_DATE)))), this.getFormattedDate(activity)})));
                break;
            }
            case TASK_DUE_DATE_DELETED: {
                csv.addCell("duedaterecord");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.task.remove", new String[]{taskName, this.getFormattedDate(activity)})));
                break;
            }
            case TASK_DUE_DATE_EXPIRED: {
                csv.addCell("duedaterecordexpiry");
                csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("com.comalatech.activity.report.dueDateRecord.task.expired", new String[]{taskName})));
            }
        }
    }

    private void addReadAckFileContent(CSVBuilder csv, Activity activity) {
        if (activity.getAction().getActionType().getSubtype() == ActionType.Subtype.READACK_COMPLETED) {
            csv.addCell("read-ack");
            csv.addCell(PageActivityEntryProcessor.removeHtmlTags(this.getTextStatic("readack.activity.report.confirmed.description", new String[]{this.getFormattedDate(activity)})));
        }
    }

    private String getFormattedDate(Activity activity) {
        return this.dateFormatter.formatServerTime(new Date(activity.getMoment()));
    }

    private String getFormattedDueDate(Date duedate) {
        return this.dateFormatter.formatExpiryDateTime(duedate);
    }

    private String getSignatureMode(ActionDetails details) {
        ESignatureCredentials.Credentials signatureMode;
        SignatureType signatureType = SignatureType.NONE;
        String signatureTypeStr = details.getDetailValue(ActionDetail.Type.APPROVAL_SIGNATURE_TYPE);
        if (signatureTypeStr != null && !signatureTypeStr.isEmpty()) {
            try {
                signatureType = SignatureType.valueOf(signatureTypeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((signatureMode = ESignatureCredentials.Credentials.fromString(details.getDetailValue(ActionDetail.Type.APPROVAL_SIGNATURE_MODE))) == ESignatureCredentials.Credentials.CONFLUENCE) {
            return this.getConfluenceSignatureMode(signatureType);
        }
        if (signatureMode == ESignatureCredentials.Credentials.OTP) {
            return this.getOTPSignatureMode(signatureType);
        }
        return "";
    }

    private String getConfluenceSignatureMode(SignatureType signatureType) {
        switch (signatureType) {
            case PASSWORD: {
                return this.getTextStatic("com.comalatech.activity.report.approval.esig.password");
            }
            case USERID_AND_PASSWORD: {
                return this.getTextStatic("com.comalatech.activity.report.approval.esig.user");
            }
        }
        return "";
    }

    private String getOTPSignatureMode(SignatureType signatureType) {
        switch (signatureType) {
            case PASSWORD: {
                return this.getTextStatic("com.comalatech.activity.report.approval.esig.otp.password");
            }
            case USERID_AND_PASSWORD: {
                return this.getTextStatic("com.comalatech.activity.report.approval.esig.otp.user");
            }
        }
        return "";
    }
}

