/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.mappers;

import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflowreports.macro.parameter.FieldListReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.StateReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.comalatech.confluence.workflowreports.model.Field;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldListParameterMapper
implements ParameterMapper {
    private static final Logger log = LoggerFactory.getLogger(FieldListParameterMapper.class);

    @Override
    public ReportParameter map(ReportParameter parameter) {
        if (this.parameterCanBeMapped(parameter)) {
            FieldListReportParameterValue fieldListReportParameterValue = this.parseFields(parameter);
            parameter.setValue(fieldListReportParameterValue);
        }
        return parameter;
    }

    @Override
    public boolean parameterCanBeMapped(ReportParameter parameter) {
        if (parameter.keyIs(StateReportParameters.CQL_FILTER.getKey()) && parameter.getValue() instanceof StringReportParameterValue) {
            try {
                FieldListReportParameterValue fieldListReportParameterValue = this.parseFields(parameter);
                if (((List)fieldListReportParameterValue.getValue()).size() > 0 || ((List)fieldListReportParameterValue.getDefaultValue()).size() > 0) {
                    return true;
                }
            }
            catch (Exception e) {
                log.debug("Error parsing fields from parameter:" + parameter + " reason:" + e.getMessage());
            }
        }
        return false;
    }

    private List<Field> extractFieldsFromExpression(String fieldsExpression) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (String fieldExpression : MiscUtils.splitAndTrim(fieldsExpression)) {
            String value;
            String[] splitField = fieldExpression.split(":");
            if (splitField.length <= 0) continue;
            String name = splitField.length > 1 ? splitField[0] : "";
            String string = value = splitField.length > 1 ? splitField[1] : "";
            if (!TextUtils.stringSet((String)name.trim()) || !TextUtils.stringSet((String)value.trim())) continue;
            fields.add(new Field(name.trim(), value.trim()));
        }
        return fields;
    }

    private FieldListReportParameterValue parseFields(ReportParameter parameter) {
        StringReportParameterValue paramValue = (StringReportParameterValue)parameter.getValue();
        String fieldsValueExpression = (String)paramValue.getValue();
        String defaultFieldsValueExpression = (String)paramValue.getDefaultValue();
        List<Field> fieldsValue = this.extractFieldsFromExpression(fieldsValueExpression);
        List<Field> defaultFieldsValue = this.extractFieldsFromExpression(defaultFieldsValueExpression);
        return new FieldListReportParameterValue(fieldsValue, defaultFieldsValue);
    }
}

