/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextCompatManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class SpaceWorkflowsAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(SpaceWorkflowsAction.class);
    private WorkflowConfigurationManager workflowConfigurationManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private WebResourceManager webResourceManager;
    private AdhocWorkflowsLicenseManager licenseManager;
    private ActionContextCompatManager actionContextCompatManager;
    private String workflowName;
    private boolean showWelcome;
    private String welcomeUrl;
    private String licenseStatusMessage;
    private String workflowsVersionNumber;
    private String workflowsVersionName;
    private static ThreadLocal<String> errorMessageThreadLocal = new ThreadLocal();
    private String docoUrl = "https://apps.appf.re/cdmdc/doc/documentmanagementdash/qe9E5b";

    public String execute() throws Exception {
        this.webResourceManager.requireResource("confluence.web.resources:jquery");
        this.webResourceManager.requireResource("confluence.web.resources:ajs");
        this.showWelcome = this.workflowConfigurationManager.getConfiguration().isShowWelcome();
        this.welcomeUrl = this.workflowConfigurationManager.getConfiguration().getWelcomeUrl();
        this.licenseStatusMessage = this.licenseManager.getLicenseStatus().getMessageHtml();
        this.workflowsVersionNumber = this.workflowConfigurationManager.getConfiguration().getWorkflowVersionNumber();
        this.workflowsVersionName = this.workflowConfigurationManager.getConfiguration().getWorkflowVersionName();
        return "success";
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    private void clearErrorMessage() {
        errorMessageThreadLocal.remove();
    }

    public String getErrorMessage() {
        String message = errorMessageThreadLocal.get();
        this.clearErrorMessage();
        return message;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public String render(String body) {
        PageContext context = new PageContext(this.getSpaceKey());
        context.pushRenderMode(RenderMode.suppress((long)1L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, body);
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isShowWelcome() {
        return this.showWelcome;
    }

    public String getWelcomeUrl() {
        return this.welcomeUrl;
    }

    public String getWorkflowsVersionNumber() {
        return this.workflowsVersionNumber;
    }

    public String getWorkflowsVersionName() {
        return this.workflowsVersionName;
    }

    public boolean isPermitted() {
        return super.isPermitted() && this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace()) && (!"promoteSpaceWorkflow".equals(this.actionContextCompatManager.getName()) || this.isConfluenceAdministrator());
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public WorkflowConfigurationManager getWorkflowConfigurationManager() {
        return this.workflowConfigurationManager;
    }

    @HtmlSafe
    public String getLicenseStatusMessage() {
        return this.licenseStatusMessage;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public String getDocoUrl() {
        return this.docoUrl;
    }

    public void setActionContextCompatManager(@Qualifier(value="actionContextCompatManager") ActionContextCompatManager actionContextCompatManager) {
        this.actionContextCompatManager = actionContextCompatManager;
    }
}

