/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.service;

import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.comalatech.confluence.readack.reports.search.HasReadAckQuery;
import com.comalatech.confluence.readack.service.ReadAckSearchService;
import com.comalatech.confluence.workflow.model.WorkflowsSearchConfluence8CompatibilityBuilder;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadAckSearchServiceImpl
implements ReadAckSearchService {
    private static final Logger log = LoggerFactory.getLogger(ReadAckSearchServiceImpl.class);
    private final SearchManager searchManager;

    public ReadAckSearchServiceImpl(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    @Override
    public boolean spaceHasReadAck(String spaceKey) {
        HashSet<HasReadAckQuery> queries = new HashSet<HasReadAckQuery>();
        queries.add(new HasReadAckQuery("true"));
        queries.add((HasReadAckQuery)new InSpaceQuery(spaceKey));
        BooleanQuery query = new BooleanQuery(queries, null, null);
        ISearch search = WorkflowsSearchConfluence8CompatibilityBuilder.getContentSearch((SearchQuery)query, (SearchSort)new TitleSort(SearchSort.Order.ASCENDING), 0, 10);
        try {
            SearchResults results = this.searchManager.search(search);
            if (results != null && results.size() > 0) {
                return true;
            }
        }
        catch (InvalidSearchException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public int getNumberOfPagesWithReadAck() {
        return this.countOnFieldName("pagehasreadack");
    }

    @Override
    public int getNumberOfWorkflowsWithReadAck() {
        return this.countOnFieldName("pageworkflowhasreadack");
    }

    @Override
    public int getNumberOfPagesWithStandaloneReadAck() {
        return this.countOnFieldName("pageHasStandaloneReadAck");
    }

    @Override
    public int getSpacesWithStandaloneReadAck() {
        return this.countOnFieldName("spaceHasStandaloneReadAck");
    }

    private int countOnFieldName(String fieldName) {
        SearchQuery query = (SearchQuery)BooleanQuery.builder().addMust((Object)WorkflowsSearchConfluence8CompatibilityBuilder.getFieldExistsQuery(fieldName)).build();
        ISearch search = WorkflowsSearchConfluence8CompatibilityBuilder.getContentSearch(query, null, 0, 10);
        try {
            return this.searchManager.search(search, null).getUnfilteredResultsCount();
        }
        catch (InvalidSearchException e) {
            log.error("Error getting the count of " + fieldName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

